/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans;

import elki.clustering.kmeans.BestOfMultipleKMeans;
import elki.clustering.kmeans.KMeans;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.MeanModel;
import elki.data.type.TypeInformation;
import elki.database.relation.ProxyView;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.result.Metadata;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.ChainedParameterization;
import elki.utilities.optionhandling.parameterization.ListParameterization;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.optionhandling.parameters.Parameter;
import java.util.LinkedList;

@Reference(authors="M. Steinbach, G. Karypis, V. Kumar", title="A Comparison of Document Clustering Techniques", booktitle="KDD workshop on text mining. Vol. 400. No. 1", url="http://glaros.dtc.umn.edu/gkhome/fetch/papers/docclusterKDDTMW00.pdf", bibkey="conf/kdd/SteinbachKK00")
public class BisectingKMeans<V extends NumberVector, M extends MeanModel>
implements KMeans<V, M> {
    private static final Logging LOG = Logging.getLogger(BisectingKMeans.class);
    private KMeans<V, M> innerkMeans;
    private int k;

    public BisectingKMeans(int k, KMeans<V, M> innerkMeans) {
        this.k = k;
        this.innerkMeans = innerkMeans;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return this.innerkMeans.getInputTypeRestriction();
    }

    @Override
    public Clustering<M> run(Relation<V> relation) {
        LinkedList currentClusterList = new LinkedList();
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Bisecting k-means", this.k - 1, LOG) : null;
        for (int j = 0; j < this.k - 1; ++j) {
            if (currentClusterList.isEmpty()) {
                currentClusterList.addAll(this.innerkMeans.run(relation).getAllClusters());
            } else {
                Cluster largestCluster = null;
                for (Cluster cluster : currentClusterList) {
                    if (largestCluster != null && cluster.size() <= largestCluster.size()) continue;
                    largestCluster = cluster;
                }
                assert (largestCluster != null);
                currentClusterList.remove(largestCluster);
                currentClusterList.addAll(this.innerkMeans.run((Relation<V>)new ProxyView(largestCluster.getIDs(), relation)).getAllClusters());
            }
            LOG.incrementProcessed((AbstractProgress)prog);
        }
        LOG.ensureCompleted(prog);
        Clustering result = new Clustering(currentClusterList);
        Metadata.of(result).setLongName("Bisecting k-Means Result");
        return result;
    }

    @Override
    public NumberVectorDistance<? super V> getDistance() {
        return this.innerkMeans.getDistance();
    }

    @Override
    public void setK(int k) {
        this.k = k;
    }

    @Override
    public void setDistance(NumberVectorDistance<? super V> distance) {
        this.innerkMeans.setDistance(distance);
    }

    @Override
    public void setInitializer(KMeansInitialization init) {
        this.innerkMeans.setInitializer(init);
    }

    public static class Par<V extends NumberVector, M extends MeanModel>
    implements Parameterizer {
        public static final OptionID KMEANS_ID = new OptionID("bisecting.kmeansvariant", "KMeans variant");
        protected KMeans<V, M> kMeansVariant;
        protected int k;

        public void configure(Parameterization config) {
            ((IntParameter)new IntParameter(KMeans.K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
            ObjectParameter kMeansVariantP = new ObjectParameter(KMEANS_ID, KMeans.class, BestOfMultipleKMeans.class);
            if (config.grab((Parameter)kMeansVariantP)) {
                ListParameterization kMeansVariantParameters = new ListParameterization();
                kMeansVariantParameters.addParameter(KMeans.K_ID, (Object)2);
                ChainedParameterization combinedConfig = new ChainedParameterization(new Parameterization[]{kMeansVariantParameters, config});
                combinedConfig.errorsTo(config);
                this.kMeansVariant = (KMeans)kMeansVariantP.instantiateClass((Parameterization)combinedConfig);
            }
        }

        public BisectingKMeans<V, M> make() {
            return new BisectingKMeans<V, M>(this.k, this.kMeansVariant);
        }
    }
}

