/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans;

import elki.clustering.kmeans.AbstractKMeans;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.KMeansModel;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.logging.Logging;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import java.util.Arrays;

@Title(value="Compare-Means")
@Reference(authors="S. J. Phillips", title="Acceleration of k-means and related clustering algorithms", booktitle="Proc. 4th Int. Workshop on Algorithm Engineering and Experiments (ALENEX 2002)", url="https://doi.org/10.1007/3-540-45643-0_13", bibkey="DBLP:conf/alenex/Phillips02")
public class CompareMeans<V extends NumberVector>
extends AbstractKMeans<V, KMeansModel> {
    private static final Logging LOG = Logging.getLogger(CompareMeans.class);

    public CompareMeans(NumberVectorDistance<? super V> distance, int k, int maxiter, KMeansInitialization initializer) {
        super(distance, k, maxiter, initializer);
    }

    @Override
    public Clustering<KMeansModel> run(Relation<V> relation) {
        Instance instance = new Instance(relation, this.distance, this.initialMeans(relation));
        instance.run(this.maxiter);
        return instance.buildResult();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V extends NumberVector>
    extends AbstractKMeans.Par<V> {
        @Override
        protected boolean needsMetric() {
            return true;
        }

        @Override
        public CompareMeans<V> make() {
            return new CompareMeans(this.distance, this.k, this.maxiter, this.initializer);
        }
    }

    protected static class Instance
    extends AbstractKMeans.Instance {
        double[][] cdist;

        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistance<?> df, double[][] means) {
            super(relation, df, means);
            this.cdist = new double[this.k][this.k];
        }

        @Override
        protected int iterate(int iteration) {
            if (iteration > 1) {
                this.means = AbstractKMeans.means(this.clusters, this.means, (Relation<? extends NumberVector>)this.relation);
            }
            this.recomputeSeperation(this.means, this.cdist);
            return this.assignToNearestCluster();
        }

        protected void recomputeSeperation(double[][] means, double[][] cdist) {
            int k = means.length;
            for (int i = 1; i < k; ++i) {
                double[] mi = means[i];
                double[] cdisti = cdist[i];
                for (int j = 0; j < i; ++j) {
                    double d = 0.5 * this.distance(mi, means[j]);
                    cdist[j][i] = d;
                    cdisti[j] = d;
                }
            }
        }

        @Override
        protected int assignToNearestCluster() {
            int changed = 0;
            Arrays.fill(this.varsum, 0.0);
            for (ModifiableDBIDs cluster : this.clusters) {
                cluster.clear();
            }
            double mult = this.isSquared ? 4.0 : 2.0;
            DBIDIter iditer = this.relation.iterDBIDs();
            while (iditer.valid()) {
                int cur = this.assignment.intValue((DBIDRef)iditer);
                int ini = cur >= 0 ? cur : 0;
                NumberVector fv = (NumberVector)this.relation.get((DBIDRef)iditer);
                double mindist = this.distance(fv, this.means[ini]);
                double threshold = mult * mindist;
                int minIndex = ini;
                for (int i = 0; i < this.k; ++i) {
                    double dist;
                    if (i == ini || this.cdist[minIndex][i] >= threshold || !((dist = this.distance(fv, this.means[i])) < mindist)) continue;
                    minIndex = i;
                    mindist = dist;
                }
                int n = minIndex;
                this.varsum[n] = this.varsum[n] + mindist;
                ((ModifiableDBIDs)this.clusters.get(minIndex)).add((DBIDRef)iditer);
                if (this.assignment.putInt((DBIDRef)iditer, minIndex) != minIndex) {
                    ++changed;
                }
                iditer.advance();
            }
            return changed;
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

