/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans;

import elki.clustering.kmeans.AbstractKMeans;
import elki.clustering.kmeans.SimplifiedElkanKMeans;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.KMeansModel;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.logging.Logging;
import elki.utilities.documentation.Reference;

@Reference(authors="C. Elkan", title="Using the triangle inequality to accelerate k-means", booktitle="Proc. 20th International Conference on Machine Learning, ICML 2003", url="http://www.aaai.org/Library/ICML/2003/icml03-022.php", bibkey="DBLP:conf/icml/Elkan03")
public class ElkanKMeans<V extends NumberVector>
extends SimplifiedElkanKMeans<V> {
    private static final Logging LOG = Logging.getLogger(ElkanKMeans.class);

    public ElkanKMeans(NumberVectorDistance<? super V> distance, int k, int maxiter, KMeansInitialization initializer, boolean varstat) {
        super(distance, k, maxiter, initializer, varstat);
    }

    @Override
    public Clustering<KMeansModel> run(Relation<V> relation) {
        Instance instance = new Instance(relation, this.distance, this.initialMeans(relation));
        instance.run(this.maxiter);
        return instance.buildResult(this.varstat, relation);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V extends NumberVector>
    extends SimplifiedElkanKMeans.Par<V> {
        @Override
        public ElkanKMeans<V> make() {
            return new ElkanKMeans(this.distance, this.k, this.maxiter, this.initializer, this.varstat);
        }
    }

    protected static class Instance
    extends SimplifiedElkanKMeans.Instance {
        double[][] cdist;

        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistance<?> df, double[][] means) {
            super(relation, df, means);
            this.cdist = new double[this.k][this.k];
        }

        @Override
        protected int initialAssignToNearestCluster() {
            assert (this.k == this.means.length);
            this.initialSeperation(this.cdist);
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                int j;
                NumberVector fv = (NumberVector)this.relation.get((DBIDRef)it);
                double[] l = (double[])this.lower.get((DBIDRef)it);
                double best = l[0] = this.sqrtdistance(fv, this.means[0]);
                int minIndex = 0;
                for (j = 1; j < this.k; ++j) {
                    double dist;
                    if (!(best > this.cdist[minIndex][j]) || !((dist = (l[j] = this.sqrtdistance(fv, this.means[j]))) < best)) continue;
                    minIndex = j;
                    best = dist;
                }
                for (j = 1; j < this.k; ++j) {
                    if (l[j] != 0.0 || j == minIndex) continue;
                    l[j] = 2.0 * this.cdist[minIndex][j] - best;
                }
                ((ModifiableDBIDs)this.clusters.get(minIndex)).add((DBIDRef)it);
                this.assignment.putInt((DBIDRef)it, minIndex);
                AbstractKMeans.plusEquals(this.sums[minIndex], fv);
                this.upper.putDouble((DBIDRef)it, best);
                it.advance();
            }
            return this.relation.size();
        }

        @Override
        protected int assignToNearestCluster() {
            this.recomputeSeperation(this.sep, this.cdist);
            int changed = 0;
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                int orig = this.assignment.intValue((DBIDRef)it);
                double u = this.upper.doubleValue((DBIDRef)it);
                if (!(u <= this.sep[orig])) {
                    boolean recompute_u = true;
                    NumberVector fv = (NumberVector)this.relation.get((DBIDRef)it);
                    double[] l = (double[])this.lower.get((DBIDRef)it);
                    int cur = orig;
                    for (int j = 0; j < this.k; ++j) {
                        double dist;
                        if (orig == j || u <= l[j] || u <= this.cdist[cur][j]) continue;
                        if (recompute_u) {
                            u = this.sqrtdistance(fv, this.means[cur]);
                            this.upper.putDouble((DBIDRef)it, u);
                            recompute_u = false;
                            if (u <= l[j] || u <= this.cdist[cur][j]) continue;
                        }
                        if (!((dist = (l[j] = this.sqrtdistance(fv, this.means[j]))) < u)) continue;
                        cur = j;
                        u = dist;
                    }
                    if (cur != orig) {
                        ((ModifiableDBIDs)this.clusters.get(cur)).add((DBIDRef)it);
                        ((ModifiableDBIDs)this.clusters.get(orig)).remove((DBIDRef)it);
                        this.assignment.putInt((DBIDRef)it, cur);
                        AbstractKMeans.plusMinusEquals(this.sums[cur], this.sums[orig], fv);
                        ++changed;
                        this.upper.putDouble((DBIDRef)it, u);
                    }
                }
                it.advance();
            }
            return changed;
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

