/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans;

import elki.clustering.kmeans.AbstractKMeans;
import elki.clustering.kmeans.HamerlyKMeans;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.KMeansModel;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.logging.Logging;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;

@Reference(authors="J. Newling", title="Fast k-means with accurate bounds", booktitle="Proc. 33nd Int. Conf. on Machine Learning, ICML 2016", url="http://jmlr.org/proceedings/papers/v48/newling16.html", bibkey="DBLP:conf/icml/NewlingF16")
@Priority(value=199)
public class ExponionKMeans<V extends NumberVector>
extends HamerlyKMeans<V> {
    private static final Logging LOG = Logging.getLogger(ExponionKMeans.class);

    public ExponionKMeans(NumberVectorDistance<? super V> distance, int k, int maxiter, KMeansInitialization initializer, boolean varstat) {
        super(distance, k, maxiter, initializer, varstat);
    }

    @Override
    public Clustering<KMeansModel> run(Relation<V> relation) {
        Instance instance = new Instance(relation, this.distance, this.initialMeans(relation));
        instance.run(this.maxiter);
        return instance.buildResult(this.varstat, relation);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V extends NumberVector>
    extends HamerlyKMeans.Par<V> {
        @Override
        public ExponionKMeans<V> make() {
            return new ExponionKMeans(this.distance, this.k, this.maxiter, this.initializer, this.varstat);
        }
    }

    protected static class Instance
    extends HamerlyKMeans.Instance {
        double[][] cdist;
        int[][] cnum;

        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistance<?> df, double[][] means) {
            super(relation, df, means);
            this.cdist = new double[this.k][this.k];
            this.cnum = new int[this.k][this.k - 1];
        }

        @Override
        protected int initialAssignToNearestCluster() {
            assert (this.k == this.means.length);
            this.computeSquaredSeparation(this.cdist);
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                NumberVector fv = (NumberVector)this.relation.get((DBIDRef)it);
                double min1 = this.distance(fv, this.means[0]);
                double min2 = this.k > 1 ? this.distance(fv, this.means[1]) : min1;
                int minIndex = 0;
                if (min2 < min1) {
                    double tmp = min1;
                    min1 = min2;
                    min2 = tmp;
                    minIndex = 1;
                }
                for (int i = 2; i < this.k; ++i) {
                    if (!(min2 > this.cdist[minIndex][i])) continue;
                    double dist = this.distance(fv, this.means[i]);
                    if (dist < min1) {
                        minIndex = i;
                        min2 = min1;
                        min1 = dist;
                        continue;
                    }
                    if (!(dist < min2)) continue;
                    min2 = dist;
                }
                ((ModifiableDBIDs)this.clusters.get(minIndex)).add((DBIDRef)it);
                this.assignment.putInt((DBIDRef)it, minIndex);
                AbstractKMeans.plusEquals(this.sums[minIndex], fv);
                this.upper.putDouble((DBIDRef)it, this.isSquared ? Math.sqrt(min1) : min1);
                this.lower.putDouble((DBIDRef)it, this.isSquared ? Math.sqrt(min2) : min2);
                it.advance();
            }
            return this.relation.size();
        }

        @Override
        protected int assignToNearestCluster() {
            this.recomputeSeperation(this.sep, this.cdist);
            AbstractKMeans.nearestMeans(this.cdist, this.cnum);
            int changed = 0;
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                int orig = this.assignment.intValue((DBIDRef)it);
                double z = this.lower.doubleValue((DBIDRef)it);
                double sa = this.sep[orig];
                double u = this.upper.doubleValue((DBIDRef)it);
                if (!(u <= z) && !(u <= sa)) {
                    NumberVector fv = (NumberVector)this.relation.get((DBIDRef)it);
                    double curd2 = this.distance(fv, this.means[orig]);
                    u = this.isSquared ? Math.sqrt(curd2) : curd2;
                    this.upper.putDouble((DBIDRef)it, u);
                    if (!(u <= z) && !(u <= sa)) {
                        int c;
                        double rhalf = u + 0.5 * sa;
                        double min1 = curd2;
                        double min2 = Double.POSITIVE_INFINITY;
                        int cur = orig;
                        for (int i = 0; i < this.k - 1 && !(this.cdist[orig][c = this.cnum[orig][i]] > rhalf); ++i) {
                            double dist = this.distance(fv, this.means[c]);
                            if (dist < min1) {
                                cur = c;
                                min2 = min1;
                                min1 = dist;
                                continue;
                            }
                            if (!(dist < min2)) continue;
                            min2 = dist;
                        }
                        if (cur != orig) {
                            ((ModifiableDBIDs)this.clusters.get(cur)).add((DBIDRef)it);
                            ((ModifiableDBIDs)this.clusters.get(orig)).remove((DBIDRef)it);
                            this.assignment.putInt((DBIDRef)it, cur);
                            AbstractKMeans.plusMinusEquals(this.sums[cur], this.sums[orig], fv);
                            ++changed;
                            this.upper.putDouble((DBIDRef)it, min1 == curd2 ? u : (this.isSquared ? Math.sqrt(min1) : min1));
                        }
                        this.lower.putDouble((DBIDRef)it, min2 == curd2 ? u : (this.isSquared ? Math.sqrt(min2) : min2));
                    }
                }
                it.advance();
            }
            return changed;
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

