/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans;

import elki.clustering.ClusteringAlgorithm;
import elki.clustering.kmeans.KMeans;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.clustering.kmeans.initialization.RandomlyChosen;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.MeanModel;
import elki.data.type.SimpleTypeInformation;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStore;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.MaterializedRelation;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.logging.Logging;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.math.linearalgebra.VMath;
import elki.result.Metadata;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.GreaterEqualConstraint;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.Arrays;
import net.jafama.FastMath;

@References(value={@Reference(authors="J. C. Dunn", title="A Fuzzy Relative of the ISODATA Process and Its Use in Detecting Compact Well-Separated Clusters", booktitle="Journal of Cybernetics 3(3)", url="https://doi.org/10.1080/01969727308546046", bibkey="doi:10.1080/01969727308546046"), @Reference(authors="J. Bezdek", title="Pattern Recognition With Fuzzy Objective Function Algorithms", booktitle="Pattern Recognition With Fuzzy Objective Function Algorithms", url="https://doi.org/10.1007/978-1-4757-0450-1", bibkey="DBLP:books/sp/Bezdek81")})
public class FuzzyCMeans<V extends NumberVector>
implements ClusteringAlgorithm<Clustering<MeanModel>> {
    private static final Logging LOG = Logging.getLogger(FuzzyCMeans.class);
    private static final String KEY = FuzzyCMeans.class.getName();
    private int k;
    private double m;
    private double delta;
    private int miniter;
    private int maxiter;
    private boolean soft;
    public static final SimpleTypeInformation<double[]> SOFT_TYPE = new SimpleTypeInformation(double[].class);
    KMeansInitialization initializer;

    public FuzzyCMeans(int k, int miniter, int maxiter, double delta, double m, boolean soft, KMeansInitialization initialization) {
        this.miniter = miniter;
        this.maxiter = maxiter;
        this.delta = delta;
        this.k = k;
        this.m = m;
        this.soft = soft;
        this.initializer = initialization;
    }

    public Clustering<MeanModel> run(Relation<V> relation) {
        if (relation.size() == 0) {
            throw new IllegalArgumentException("database empty: must contain elements");
        }
        int d = ((NumberVector)relation.get((DBIDRef)relation.iterDBIDs())).getDimensionality();
        WritableDataStore probClusterIGivenX = DataStoreUtil.makeStorage((DBIDs)relation.getDBIDs(), (int)10, double[].class);
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            probClusterIGivenX.put((DBIDRef)iditer, (Object)new double[this.k]);
            iditer.advance();
        }
        double[][] means = this.initializer.chooseInitialMeans((Relation<? extends NumberVector>)relation, this.k, (NumberVectorDistance<?>)SquaredEuclideanDistance.STATIC);
        DoubleStatistic changestat = new DoubleStatistic(this.getClass().getName() + ".weightChange");
        DoubleStatistic objstat = new DoubleStatistic(this.getClass().getName() + ".objectiveValue");
        int it = 0;
        int lastimprovement = 0;
        double bestWeightChange = 1.0;
        ++it;
        while (it < this.maxiter || this.maxiter < 0) {
            double weightChange = this.assignProbabilitiesToInstances(relation, means, (WritableDataStore<double[]>)probClusterIGivenX);
            LOG.statistics((Statistic)changestat.setDouble(weightChange));
            if (bestWeightChange - weightChange > this.delta) {
                lastimprovement = it;
                bestWeightChange = weightChange;
            }
            if (it >= this.miniter && (weightChange <= this.delta || lastimprovement < it >> 1)) break;
            double objectiveValue = this.updateMeans(relation, (WritableDataStore<double[]>)probClusterIGivenX, means, d);
            LOG.statistics((Statistic)objstat.setDouble(objectiveValue));
            ++it;
        }
        LOG.statistics((Statistic)new LongStatistic(KEY + ".iterations", (long)it));
        Clustering<MeanModel> result = new Clustering<MeanModel>();
        Metadata.of(result).setLongName("FCM Clustering");
        ArrayList<ArrayModifiableDBIDs> hardClusters = new ArrayList<ArrayModifiableDBIDs>(this.k);
        for (int i = 0; i < this.k; ++i) {
            hardClusters.add(DBIDUtil.newArray());
        }
        DBIDIter iditer2 = relation.iterDBIDs();
        while (iditer2.valid()) {
            ((ModifiableDBIDs)hardClusters.get(VMath.argmax((double[])((double[])probClusterIGivenX.get((DBIDRef)iditer2))))).add((DBIDRef)iditer2);
            iditer2.advance();
        }
        for (int i = 0; i < this.k; ++i) {
            result.addToplevelCluster(new Cluster<MeanModel>((DBIDs)hardClusters.get(i), new MeanModel(means[i])));
        }
        if (this.soft) {
            Metadata.hierarchyOf(result).addChild((Object)new MaterializedRelation("FCM Cluster Probabilities", SOFT_TYPE, relation.getDBIDs(), (DataStore)probClusterIGivenX));
        } else {
            probClusterIGivenX.destroy();
        }
        return result;
    }

    private double updateMeans(Relation<V> relation, WritableDataStore<double[]> probClusterIGivenX, double[][] means, int d) {
        double[] weight = new double[this.k];
        double[][] tmeans = new double[this.k][d];
        double objvalue = 0.0;
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            double[] p = ((NumberVector)relation.get((DBIDRef)iditer)).toArray();
            double[] probs = (double[])probClusterIGivenX.get((DBIDRef)iditer);
            for (int i = 0; i < this.k; ++i) {
                double w = FastMath.pow((double)probs[i], (double)this.m);
                int n = i;
                weight[n] = weight[n] + w;
                VMath.plusTimesEquals((double[])tmeans[i], (double[])p, (double)w);
                objvalue += w * this.distance(p, means[i]);
            }
            iditer.advance();
        }
        for (int i = 0; i < this.k; ++i) {
            means[i] = VMath.times((double[])tmeans[i], (double)(1.0 / weight[i]));
        }
        return objvalue;
    }

    public double assignProbabilitiesToInstances(Relation<V> relation, double[][] centers, WritableDataStore<double[]> probClusterIGivenX) {
        int k = centers.length;
        double exp = -1.0 / (this.m - 1.0);
        double[] oldprobs = new double[k];
        double weightChange = 0.0;
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            int i;
            NumberVector vec = (NumberVector)relation.get((DBIDRef)iditer);
            double[] probs = (double[])probClusterIGivenX.get((DBIDRef)iditer);
            System.arraycopy(probs, 0, oldprobs, 0, k);
            int dirass = -1;
            double sumprob = 0.0;
            for (i = 0; i < k; ++i) {
                double di = this.distance(vec, centers[i]);
                if (di == 0.0) {
                    Arrays.fill(probs, 0.0);
                    dirass = i;
                    probs[dirass] = 1.0;
                    break;
                }
                probs[i] = exp != 1.0 ? FastMath.pow((double)di, (double)exp) : 1.0 / di;
                double p = probs[i];
                sumprob += p;
            }
            if (Double.isInfinite(sumprob)) {
                dirass = VMath.argmax((double[])probs);
                Arrays.fill(probs, 0.0);
                probs[dirass] = 1.0;
            }
            if (dirass < 0) {
                VMath.timesEquals((double[])probs, (double)(1.0 / sumprob));
            }
            for (i = 0; i < k; ++i) {
                double v = probs[i] - oldprobs[i];
                weightChange += v * v;
            }
            iditer.advance();
        }
        return weightChange / (double)(relation.size() * k);
    }

    private double distance(V v1, double[] v2) {
        double acc = 0.0;
        for (int d = 0; d < v2.length; ++d) {
            double v = v1.doubleValue(d) - v2[d];
            acc += v * v;
        }
        return acc;
    }

    private double distance(double[] v1, double[] v2) {
        double acc = 0.0;
        for (int d = 0; d < v2.length; ++d) {
            double v = v1[d] - v2[d];
            acc += v * v;
        }
        return acc;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID K_ID = new OptionID("fcm.k", "The number of clusters to find.");
        public static final OptionID DELTA_ID = new OptionID("fcm.delta", "The termination criterion for maximization: Frob(u^{t-1} - u^{t})^2 / (N * k) <= fcm.delta");
        public static final OptionID MINITER_ID = new OptionID("fcm.miniter", "Minimum number of iterations.");
        public static final OptionID M_ID = new OptionID("fcm.m", "Weight exponent.");
        public static final OptionID SOFT_ID = new OptionID("fcm.soft", "Retain soft assignments.");
        public static final OptionID INIT_ID = new OptionID("fcm.init", "Cluster Initialization");
        protected int k;
        protected double delta;
        protected int miniter = 1;
        protected int maxiter = -1;
        protected double m = 2.0;
        protected boolean soft = false;
        KMeansInitialization initializer;

        public void configure(Parameterization config) {
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
            new ObjectParameter(INIT_ID, KMeansInitialization.class, RandomlyChosen.class).grab(config, x -> {
                this.initializer = x;
            });
            ((DoubleParameter)new DoubleParameter(DELTA_ID, 1.0E-7).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).grab(config, x -> {
                this.delta = x;
            });
            ((DoubleParameter)new DoubleParameter(M_ID, 2.0).addConstraint((ParameterConstraint)new GreaterEqualConstraint(1.01))).grab(config, x -> {
                this.m = x;
            });
            ((IntParameter)((IntParameter)new IntParameter(MINITER_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).setDefaultValue((Object)1)).grab(config, x -> {
                this.miniter = x;
            });
            ((IntParameter)((IntParameter)new IntParameter(KMeans.MAXITER_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_INT)).setOptional(true)).grab(config, x -> {
                this.maxiter = x;
            });
            new Flag(SOFT_ID).grab(config, x -> {
                this.soft = x;
            });
        }

        public FuzzyCMeans<NumberVector> make() {
            return new FuzzyCMeans<NumberVector>(this.k, this.miniter, this.maxiter, this.delta, this.m, this.soft, this.initializer);
        }
    }
}

