/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans;

import elki.clustering.kmeans.AbstractKMeans;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.KMeansModel;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.logging.Logging;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.parameterization.Parameterization;
import java.util.Arrays;

@Reference(authors="G. Hamerly", title="Making k-means even faster", booktitle="Proc. 2010 SIAM International Conference on Data Mining", url="https://doi.org/10.1137/1.9781611972801.12", bibkey="DBLP:conf/sdm/Hamerly10")
public class HamerlyKMeans<V extends NumberVector>
extends AbstractKMeans<V, KMeansModel> {
    private static final Logging LOG = Logging.getLogger(HamerlyKMeans.class);
    protected boolean varstat = false;

    public HamerlyKMeans(NumberVectorDistance<? super V> distance, int k, int maxiter, KMeansInitialization initializer, boolean varstat) {
        super(distance, k, maxiter, initializer);
        this.varstat = varstat;
    }

    @Override
    public Clustering<KMeansModel> run(Relation<V> relation) {
        Instance instance = new Instance(relation, this.distance, this.initialMeans(relation));
        instance.run(this.maxiter);
        return instance.buildResult(this.varstat, relation);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V extends NumberVector>
    extends AbstractKMeans.Par<V> {
        @Override
        protected boolean needsMetric() {
            return true;
        }

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            super.getParameterVarstat(config);
        }

        @Override
        public HamerlyKMeans<V> make() {
            return new HamerlyKMeans(this.distance, this.k, this.maxiter, this.initializer, this.varstat);
        }
    }

    protected static class Instance
    extends AbstractKMeans.Instance {
        double[][] sums;
        double[][] newmeans;
        WritableDoubleDataStore upper;
        WritableDoubleDataStore lower;
        double[] sep;

        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistance<?> df, double[][] means) {
            super(relation, df, means);
            this.upper = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)3, (double)Double.POSITIVE_INFINITY);
            this.lower = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)3, (double)0.0);
            int dim = means[0].length;
            this.sums = new double[this.k][dim];
            this.newmeans = new double[this.k][dim];
            this.sep = new double[this.k];
        }

        @Override
        protected int iterate(int iteration) {
            if (iteration == 1) {
                return this.initialAssignToNearestCluster();
            }
            this.meansFromSums(this.newmeans, this.sums, this.means);
            this.movedDistance(this.means, this.newmeans, this.sep);
            this.updateBounds(this.sep);
            this.copyMeans(this.newmeans, this.means);
            return this.assignToNearestCluster();
        }

        protected int initialAssignToNearestCluster() {
            assert (this.k == this.means.length);
            double[][] cdist = new double[this.k][this.k];
            this.computeSquaredSeparation(cdist);
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                NumberVector fv = (NumberVector)this.relation.get((DBIDRef)it);
                double min1 = this.distance(fv, this.means[0]);
                double min2 = this.k > 1 ? this.distance(fv, this.means[1]) : min1;
                int minIndex = 0;
                if (min2 < min1) {
                    double tmp = min1;
                    min1 = min2;
                    min2 = tmp;
                    minIndex = 1;
                }
                for (int i = 2; i < this.k; ++i) {
                    if (!(min2 > cdist[minIndex][i])) continue;
                    double dist = this.distance(fv, this.means[i]);
                    if (dist < min1) {
                        minIndex = i;
                        min2 = min1;
                        min1 = dist;
                        continue;
                    }
                    if (!(dist < min2)) continue;
                    min2 = dist;
                }
                ((ModifiableDBIDs)this.clusters.get(minIndex)).add((DBIDRef)it);
                this.assignment.putInt((DBIDRef)it, minIndex);
                AbstractKMeans.plusEquals(this.sums[minIndex], fv);
                this.upper.putDouble((DBIDRef)it, this.isSquared ? Math.sqrt(min1) : min1);
                this.lower.putDouble((DBIDRef)it, this.isSquared ? Math.sqrt(min2) : min2);
                it.advance();
            }
            return this.relation.size();
        }

        @Override
        protected int assignToNearestCluster() {
            this.recomputeSeperation(this.sep);
            int changed = 0;
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                int orig = this.assignment.intValue((DBIDRef)it);
                double l = this.lower.doubleValue((DBIDRef)it);
                double sa = this.sep[orig];
                double u = this.upper.doubleValue((DBIDRef)it);
                if (!(u <= l) && !(u <= sa)) {
                    NumberVector fv = (NumberVector)this.relation.get((DBIDRef)it);
                    double curd2 = this.distance(fv, this.means[orig]);
                    u = this.isSquared ? Math.sqrt(curd2) : curd2;
                    this.upper.putDouble((DBIDRef)it, u);
                    if (!(u <= l) && !(u <= sa)) {
                        double min1 = curd2;
                        double min2 = Double.POSITIVE_INFINITY;
                        int cur = orig;
                        for (int i = 0; i < this.k; ++i) {
                            if (i == orig) continue;
                            double dist = this.distance(fv, this.means[i]);
                            if (dist < min1) {
                                cur = i;
                                min2 = min1;
                                min1 = dist;
                                continue;
                            }
                            if (!(dist < min2)) continue;
                            min2 = dist;
                        }
                        if (cur != orig) {
                            ((ModifiableDBIDs)this.clusters.get(cur)).add((DBIDRef)it);
                            ((ModifiableDBIDs)this.clusters.get(orig)).remove((DBIDRef)it);
                            this.assignment.putInt((DBIDRef)it, cur);
                            AbstractKMeans.plusMinusEquals(this.sums[cur], this.sums[orig], fv);
                            ++changed;
                            this.upper.putDouble((DBIDRef)it, min1 == curd2 ? u : (this.isSquared ? Math.sqrt(min1) : min1));
                        }
                        this.lower.putDouble((DBIDRef)it, min2 == curd2 ? u : (this.isSquared ? Math.sqrt(min2) : min2));
                    }
                }
                it.advance();
            }
            return changed;
        }

        protected void recomputeSeperation(double[] sep) {
            int i;
            int k = this.means.length;
            assert (sep.length == k);
            Arrays.fill(sep, Double.POSITIVE_INFINITY);
            for (i = 1; i < k; ++i) {
                double[] m1 = this.means[i];
                for (int j = 0; j < i; ++j) {
                    double d = this.distance(m1, this.means[j]);
                    sep[i] = d < sep[i] ? d : sep[i];
                    sep[j] = d < sep[j] ? d : sep[j];
                }
            }
            for (i = 0; i < k; ++i) {
                sep[i] = 0.5 * (this.isSquared ? Math.sqrt(sep[i]) : sep[i]);
            }
        }

        protected void updateBounds(double[] move) {
            int most = 0;
            double delta = move[0];
            double delta2 = 0.0;
            for (int i = 1; i < move.length; ++i) {
                double m = move[i];
                if (m > delta) {
                    delta2 = delta;
                    most = i;
                    delta = move[most];
                    continue;
                }
                if (!(m > delta2)) continue;
                delta2 = m;
            }
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                int a = this.assignment.intValue((DBIDRef)it);
                this.upper.increment((DBIDRef)it, move[a]);
                this.lower.increment((DBIDRef)it, a == most ? -delta2 : -delta);
                it.advance();
            }
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

