/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans;

import elki.clustering.kmeans.AbstractKMeans;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.KMeansModel;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.logging.Logging;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.parameterization.Parameterization;
import java.util.Arrays;

@Reference(authors="J. A. Hartigan, M. A. Wong", title="Algorithm AS 136: A K-Means Clustering Algorithm", booktitle="J. Royal Statistical Society. Series C (Applied Statistics) 28(1)", url="https://doi.org/10.2307/2346830", bibkey="doi:10.2307/2346830")
public class HartiganWongKMeans<V extends NumberVector>
extends AbstractKMeans<V, KMeansModel> {
    private static final Logging LOG = Logging.getLogger(HartiganWongKMeans.class);

    public HartiganWongKMeans(int k, KMeansInitialization initializer) {
        super(SquaredEuclideanDistance.STATIC, k, 0, initializer);
    }

    @Override
    public Clustering<KMeansModel> run(Relation<V> rel) {
        Instance instance = new Instance(rel, this.getDistance(), this.initialMeans(rel));
        instance.run(this.maxiter);
        return instance.buildResult();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractKMeans.Par<V> {
        @Override
        public void configure(Parameterization config) {
            this.getParameterK(config);
            this.getParameterInitialization(config);
        }

        @Override
        public HartiganWongKMeans<V> make() {
            return new HartiganWongKMeans(this.k, this.initializer);
        }
    }

    protected static class Instance
    extends AbstractKMeans.Instance {
        WritableIntegerDataStore secondary;
        WritableDoubleDataStore r1s;
        int[] ncp;
        int[] live;
        boolean[] itran;
        double[] an1;
        double[] an2;
        private int optries;

        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistance<?> df, double[][] means) {
            super(relation, df, means);
            this.secondary = DataStoreUtil.makeIntegerStorage((DBIDs)relation.getDBIDs(), (int)3, (int)0);
            this.r1s = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)1, (double)Double.POSITIVE_INFINITY);
            this.ncp = new int[this.k];
            this.live = new int[this.k];
            this.itran = new boolean[this.k];
            this.an1 = new double[this.k];
            this.an2 = new double[this.k];
            this.optries = 0;
        }

        @Override
        protected int iterate(int iteration) {
            if (iteration == 1) {
                int changed = this.initialAssignToNearestCluster();
                this.means = AbstractKMeans.means(this.clusters, this.means, (Relation<? extends NumberVector>)this.relation);
                this.initialize();
                return changed;
            }
            if (iteration > 2 && this.k == 2) {
                return 0;
            }
            int changed = this.optimalTransfer();
            if (this.optries == this.relation.size()) {
                return 0;
            }
            return changed += this.quickTransfer();
        }

        private int initialAssignToNearestCluster() {
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                double bdist;
                NumberVector fv = (NumberVector)this.relation.get((DBIDRef)it);
                int best = 0;
                int sec = 0;
                double sdist = bdist = this.distance(fv, this.means[0]);
                for (int i = 1; i < this.means.length; ++i) {
                    double d = this.distance(fv, this.means[i]);
                    if (d < bdist) {
                        sec = best;
                        sdist = bdist;
                        best = i;
                        bdist = d;
                        continue;
                    }
                    if (!(d < sdist)) continue;
                    sec = i;
                    sdist = d;
                }
                ((ModifiableDBIDs)this.clusters.get(best)).add((DBIDRef)it);
                this.assignment.putInt((DBIDRef)it, best);
                this.secondary.putInt((DBIDRef)it, sec);
                it.advance();
            }
            return this.relation.size();
        }

        private void initialize() {
            for (int l = 0; l < this.means.length; ++l) {
                int aa = ((ModifiableDBIDs)this.clusters.get(l)).size();
                this.an2[l] = (double)aa / (double)(aa + 1);
                this.an1[l] = aa >= 1 ? (double)aa / (double)(aa - 1) : Double.POSITIVE_INFINITY;
            }
            Arrays.fill(this.itran, true);
            Arrays.fill(this.ncp, -1);
        }

        private int optimalTransfer() {
            int m = this.relation.size();
            Arrays.fill(this.ncp, -1);
            for (int j = 0; j < this.means.length; ++j) {
                if (!this.itran[j]) continue;
                this.live[j] = m;
            }
            int changed = 0;
            int i = 0;
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid() && this.optries < m) {
                ++this.optries;
                int l1 = this.assignment.intValue((DBIDRef)it);
                if (((ModifiableDBIDs)this.clusters.get(l1)).size() != 1) {
                    int l2;
                    NumberVector vec = (NumberVector)this.relation.get((DBIDRef)it);
                    double r1 = this.ncp[l1] >= 0 ? this.cacheR1(it, vec, l1) : this.r1s.doubleValue((DBIDRef)it);
                    int newl2 = l2 = this.assignment.intValue((DBIDRef)it);
                    double r2 = Double.POSITIVE_INFINITY;
                    boolean ilivel1 = i < this.live[l1];
                    for (int l = 0; l < this.means.length; ++l) {
                        double rr2;
                        if (l == l1 || l == l2 || !ilivel1 && i >= this.live[l] || !((rr2 = this.distance(vec, this.means[l]) * this.an2[l]) < r2)) continue;
                        r2 = rr2;
                        newl2 = l;
                    }
                    if (r2 < r1) {
                        this.optries = 0;
                        this.live[l1] = this.live[newl2] = this.relation.size() + i;
                        this.ncp[l1] = this.ncp[newl2] = i;
                        this.transfer((DBIDRef)it, vec, l1, newl2);
                        ++changed;
                    } else if (newl2 != l2) {
                        this.secondary.putInt((DBIDRef)it, newl2);
                    }
                }
                it.advance();
                ++i;
            }
            int k = 0;
            while (k < this.live.length) {
                int n = k++;
                this.live[n] = this.live[n] - m;
            }
            return changed;
        }

        private int quickTransfer() {
            Arrays.fill(this.itran, false);
            int changed = 0;
            int icoun = 0;
            int istep = 0;
            while (icoun < this.relation.size()) {
                DBIDIter it = this.relation.iterDBIDs();
                while (it.valid()) {
                    ++icoun;
                    ++istep;
                    int l1 = this.assignment.intValue((DBIDRef)it);
                    int l2 = this.secondary.intValue((DBIDRef)it);
                    if (((ModifiableDBIDs)this.clusters.get(l1)).size() != 1) {
                        double r1;
                        NumberVector vec = (NumberVector)this.relation.get((DBIDRef)it);
                        double d = r1 = istep < this.ncp[l1] ? this.cacheR1(it, vec, l1) : this.r1s.doubleValue((DBIDRef)it);
                        if ((istep <= this.ncp[l1] || istep <= this.ncp[l2]) && r1 > this.distance(vec, this.means[l2]) * this.an2[l2]) {
                            this.optries = 0;
                            icoun = 0;
                            this.itran[l2] = true;
                            this.itran[l1] = true;
                            this.ncp[l1] = this.ncp[l2] = istep + this.relation.size() - 1;
                            this.transfer((DBIDRef)it, vec, l1, l2);
                            ++changed;
                        }
                    }
                    it.advance();
                }
            }
            return changed;
        }

        private double cacheR1(DBIDIter it, NumberVector vec, int l1) {
            double r1 = this.distance(vec, this.means[l1]) * this.an1[l1];
            this.r1s.putDouble((DBIDRef)it, r1);
            return r1;
        }

        private void transfer(DBIDRef it, NumberVector vec, int l1, int l2) {
            int al1 = ((ModifiableDBIDs)this.clusters.get(l1)).size();
            int alw = al1 - 1;
            int al2 = ((ModifiableDBIDs)this.clusters.get(l2)).size();
            int alt = al2 + 1;
            double[] mean1 = this.means[l1];
            double[] mean2 = this.means[l2];
            for (int j = 0; j < mean1.length; ++j) {
                mean1[j] = (mean1[j] * (double)al1 - vec.doubleValue(j)) / (double)alw;
                mean2[j] = (mean2[j] * (double)al2 + vec.doubleValue(j)) / (double)alt;
            }
            this.an2[l1] = (double)alw / (double)al1;
            this.an1[l1] = alw > 1 ? (double)alw / (double)(alw - 1) : Double.POSITIVE_INFINITY;
            this.an1[l2] = (double)alt / (double)al2;
            this.an2[l2] = (double)alt / (double)(alt + 1);
            ((ModifiableDBIDs)this.clusters.get(l1)).remove(it);
            ((ModifiableDBIDs)this.clusters.get(l2)).add(it);
            this.assignment.put(it, l2);
            this.secondary.put(it, l1);
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

