/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans;

import elki.clustering.kmeans.KDTreePruningKMeans;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.KMeansModel;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.logging.Logging;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.documentation.Title;

@Title(value="K-d-tree K-means with Filtering")
@References(value={@Reference(authors="D. Pelleg, A. Moore", title="Accelerating Exact k-means Algorithms with Geometric Reasoning", booktitle="Proc. ACM SIGKDD Int. Conf. Knowledge Discovery and Data Mining", url="https://doi.org/10.1145/312129.312248", bibkey="DBLP:conf/kdd/PellegM99"), @Reference(authors="T. Kanungo, D. M. Mount, N. S. Netanyahu, C. D. Piatko, R. Silverman, A. Y. Wu", title="Computing Nearest Neighbors for Moving Points and Applications to Clustering", booktitle="Proc. 10th ACM-SIAM Symposium on Discrete Algorithms (SODA'99)", url="http://dl.acm.org/citation.cfm?id=314500.315095", bibkey="DBLP:conf/soda/KanungoMNPSW99"), @Reference(authors="T. Kanungo, D. M. Mount, N. S. Netanyahu, C. D. Piatko, R. Silverman, A. Y. Wu", title="An Efficient k-Means Clustering Algorithm: Analysis and Implementation", booktitle="IEEE Transactions on Pattern Analysis and Machine Intelligence 24(7)", url="https://doi.org/10.1109/TPAMI.2002.1017616", bibkey="DBLP:journals/pami/KanungoMNPSW02")})
public class KDTreeFilteringKMeans<V extends NumberVector>
extends KDTreePruningKMeans<V> {
    private static final Logging LOG = Logging.getLogger(KDTreeFilteringKMeans.class);

    public KDTreeFilteringKMeans(NumberVectorDistance<? super V> distance, int k, int maxiter, KMeansInitialization initializer, KDTreePruningKMeans.Split split, int leafsize) {
        super(distance, k, maxiter, initializer, split, leafsize);
    }

    @Override
    public Clustering<KMeansModel> run(Relation<V> relation) {
        Instance instance = new Instance(relation, this.distance, this.initialMeans(relation));
        instance.run(this.maxiter);
        return instance.buildResult();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V extends NumberVector>
    extends KDTreePruningKMeans.Par<V> {
        @Override
        public KDTreeFilteringKMeans<V> make() {
            return new KDTreeFilteringKMeans(this.distance, this.k, this.maxiter, this.initializer, this.split, this.leafsize);
        }
    }

    protected class Instance
    extends KDTreePruningKMeans.Instance {
        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistance<?> df, double[][] means) {
            super(relation, df, means);
        }

        @Override
        protected int pruning(KDTreePruningKMeans.KDNode u, int alive) {
            double[] mid = u.mid;
            double[] halfwidth = u.halfwidth;
            int nearest = this.getNearestCenter(mid, alive);
            if (nearest > 0) {
                int swap = this.indices[0];
                this.indices[0] = this.indices[nearest];
                this.indices[nearest] = swap;
            }
            double[] nmean = this.means[this.indices[0]];
            int i = 1;
            while (i < alive) {
                if (this.isFarther(nmean, this.means[this.indices[i]], mid, halfwidth)) {
                    int swap = this.indices[i];
                    this.indices[i] = this.indices[--alive];
                    this.indices[alive] = swap;
                    continue;
                }
                ++i;
            }
            return alive;
        }

        protected int getNearestCenter(double[] mid, int alive) {
            int best = 0;
            double bestDistance = Double.POSITIVE_INFINITY;
            for (int i = 0; i < alive; ++i) {
                double distance = this.distance(mid, this.means[this.indices[i]]);
                if (!(distance < bestDistance)) continue;
                best = i;
                bestDistance = distance;
            }
            return best;
        }

        protected boolean isFarther(double[] z_star, double[] z, double[] mid, double[] halfwidth) {
            ++this.diststat;
            double diff = 0.0;
            for (int i = 0; i < z.length; ++i) {
                double v = z[i] < z_star[i] ? mid[i] - halfwidth[i] : mid[i] + halfwidth[i];
                double delta1 = z_star[i] - v;
                double delta2 = z[i] - v;
                diff += delta1 * delta1 - delta2 * delta2;
            }
            return diff < 0.0;
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

