/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans;

import elki.clustering.kmeans.AbstractKMeans;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.KMeansModel;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDList;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.DoubleDBIDListMIter;
import elki.database.ids.ModifiableDoubleDBIDList;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.logging.Logging;
import elki.math.linearalgebra.VMath;
import elki.result.Metadata;
import elki.utilities.datastructures.heap.DoubleMinHeap;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.Flag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Title(value="K-Means--")
@Reference(authors="S. Chawla, A. Gionis", title="k-means--: A Unified Approach to Clustering and Outlier Detection", booktitle="Proc. 13th SIAM Int. Conf. on Data Mining (SDM 2013)", url="https://doi.org/10.1137/1.9781611972832.21", bibkey="DBLP:conf/sdm/ChawlaG13")
public class KMeansMinusMinus<V extends NumberVector>
extends AbstractKMeans<V, KMeansModel> {
    private static final Logging LOG = Logging.getLogger(KMeansMinusMinus.class);
    public double rate;
    public boolean noiseFlag;

    public KMeansMinusMinus(NumberVectorDistance<? super V> distance, int k, int maxiter, KMeansInitialization initializer, double rate, boolean noiseFlag) {
        super(distance, k, maxiter, initializer);
        this.rate = rate;
        this.noiseFlag = noiseFlag;
    }

    @Override
    public Clustering<KMeansModel> run(Relation<V> relation) {
        Instance instance = new Instance(relation, this.distance, this.initialMeans(relation));
        instance.run(this.maxiter);
        return instance.buildResultWithNoise();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V extends NumberVector>
    extends AbstractKMeans.Par<V> {
        public static final OptionID RATE_ID = new OptionID("kmeansmm.l", "Number of outliers to ignore, or (if less than 1) a relative rate.");
        public static final OptionID NOISE_FLAG_ID = new OptionID("kmeansmm.noisecluster", "Create a noise cluster, instead of assigning the noise objects.");
        private double rate;
        private boolean noiseFlag;

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            ((DoubleParameter)new DoubleParameter(RATE_ID, 0.05).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).grab(config, x -> {
                this.rate = x;
            });
            new Flag(NOISE_FLAG_ID).grab(config, x -> {
                this.noiseFlag = x;
            });
        }

        @Override
        public KMeansMinusMinus<V> make() {
            return new KMeansMinusMinus(this.distance, this.k, this.maxiter, this.initializer, this.rate, this.noiseFlag);
        }
    }

    protected class Instance
    extends AbstractKMeans.Instance {
        DoubleMinHeap minHeap;
        int heapsize;
        double prevvartotal;
        List<ModifiableDoubleDBIDList> clusters;

        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistance<?> df, double[][] means) {
            super(relation, df, means);
            this.prevvartotal = Double.POSITIVE_INFINITY;
            this.heapsize = (int)(KMeansMinusMinus.this.rate < 1.0 ? Math.ceil((double)relation.size() * KMeansMinusMinus.this.rate) : KMeansMinusMinus.this.rate);
            this.minHeap = new DoubleMinHeap(this.heapsize);
            this.clusters = new ArrayList<ModifiableDoubleDBIDList>();
            for (int i = 0; i < this.k; ++i) {
                this.clusters.add(DBIDUtil.newDistanceDBIDList((int)((int)((double)relation.size() * 2.0 / (double)this.k))));
            }
            ((AbstractKMeans.Instance)this).clusters = null;
        }

        @Override
        protected int iterate(int iteration) {
            if (iteration > 1) {
                this.means = this.meansWithTreshhold(this.heapsize == 0 || this.minHeap.size() < this.heapsize ? Double.POSITIVE_INFINITY : this.minHeap.peek());
            }
            this.minHeap.clear();
            for (int i = 0; i < this.k; ++i) {
                this.clusters.get(i).clear();
            }
            int changed = this.assignToNearestCluster();
            double vartotal = VMath.sum((double[])this.varsum);
            if (vartotal > this.prevvartotal) {
                return -changed;
            }
            this.prevvartotal = vartotal;
            return changed;
        }

        protected Clustering<KMeansModel> buildResultWithNoise() {
            ModifiableDoubleDBIDList noiseids = null;
            if (KMeansMinusMinus.this.noiseFlag && this.heapsize > 0) {
                noiseids = DBIDUtil.newDistanceDBIDList((int)this.minHeap.size());
                this.clusters.add(noiseids);
                double tresh = this.minHeap.peek();
                for (int i = 0; i < this.k; ++i) {
                    DoubleDBIDListMIter it = this.clusters.get(i).iter();
                    while (it.valid()) {
                        double dist = it.doubleValue();
                        if (dist >= tresh) {
                            noiseids.add(dist, (DBIDRef)it);
                            this.assignment.putInt((DBIDRef)it, this.k);
                            it.remove();
                        }
                        it.advance();
                    }
                }
            }
            Clustering<KMeansModel> result = new Clustering<KMeansModel>();
            Metadata.of(result).setLongName("k-Means-- Clustering");
            for (int i = 0; i < this.k; ++i) {
                DBIDs ids = (DBIDs)this.clusters.get(i);
                if (ids.isEmpty()) continue;
                result.addToplevelCluster(new Cluster<KMeansModel>(ids, new KMeansModel(this.means[i], this.varsum[i])));
            }
            if (KMeansMinusMinus.this.noiseFlag && noiseids != null && !noiseids.isEmpty()) {
                result.addToplevelCluster(new Cluster<KMeansModel>((DBIDs)noiseids, true, new KMeansModel(null, 0.0)));
            }
            return result;
        }

        @Override
        protected int assignToNearestCluster() {
            assert (this.k == this.means.length);
            int changed = 0;
            Arrays.fill(this.varsum, 0.0);
            DBIDIter iditer = this.relation.iterDBIDs();
            while (iditer.valid()) {
                NumberVector fv = (NumberVector)this.relation.get((DBIDRef)iditer);
                double mindist = Double.POSITIVE_INFINITY;
                int minIndex = 0;
                for (int i = 0; i < this.k; ++i) {
                    double dist = this.distance(fv, this.means[i]);
                    if (!(dist < mindist)) continue;
                    minIndex = i;
                    mindist = dist;
                }
                if (this.heapsize > 0) {
                    this.minHeap.add(mindist, this.heapsize);
                }
                int n = minIndex;
                this.varsum[n] = this.varsum[n] + mindist;
                this.clusters.get(minIndex).add(mindist, (DBIDRef)iditer);
                if (this.assignment.putInt((DBIDRef)iditer, minIndex) != minIndex) {
                    ++changed;
                }
                iditer.advance();
            }
            return changed;
        }

        protected double[][] meansWithTreshhold(double tresh) {
            double[][] newMeans = new double[this.k][];
            for (int i = 0; i < this.k; ++i) {
                DoubleDBIDList list = (DoubleDBIDList)this.clusters.get(i);
                double[] raw = null;
                int count = 0;
                DoubleDBIDListIter iter = list.iter();
                while (iter.valid()) {
                    if (!(iter.doubleValue() >= tresh)) {
                        NumberVector vec = (NumberVector)this.relation.get((DBIDRef)iter);
                        if (raw == null) {
                            raw = vec.toArray();
                        } else {
                            AbstractKMeans.plusEquals(raw, vec);
                        }
                        ++count;
                    }
                    iter.advance();
                }
                newMeans[i] = raw != null ? VMath.timesEquals(raw, (double)(1.0 / (double)count)) : this.means[i];
            }
            return newMeans;
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

