/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans;

import elki.clustering.kmeans.AbstractKMeans;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.VectorUtil;
import elki.data.model.MeanModel;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.QuickSelectDBIDs;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.logging.Logging;
import elki.result.Metadata;
import elki.utilities.documentation.Reference;
import java.util.Comparator;
import java.util.List;

@Reference(title="Clustering via Concave Minimization", authors="P. S. Bradley, O. L. Mangasarian, W. N. Street", booktitle="Advances in Neural Information Processing Systems", url="https://papers.nips.cc/paper/1260-clustering-via-concave-minimization", bibkey="DBLP:conf/nips/BradleyMS96")
public class KMediansLloyd<V extends NumberVector>
extends AbstractKMeans<V, MeanModel> {
    private static final Logging LOG = Logging.getLogger(KMediansLloyd.class);

    public KMediansLloyd(NumberVectorDistance<? super V> distance, int k, int maxiter, KMeansInitialization initializer) {
        super(distance, k, maxiter, initializer);
    }

    @Override
    public Clustering<MeanModel> run(Relation<V> relation) {
        Instance instance = new Instance(relation, this.distance, this.initialMeans(relation));
        instance.run(this.maxiter);
        return instance.buildMediansResult();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V extends NumberVector>
    extends AbstractKMeans.Par<V> {
        @Override
        public KMediansLloyd<V> make() {
            return new KMediansLloyd(this.distance, this.k, this.maxiter, this.initializer);
        }
    }

    protected static class Instance
    extends AbstractKMeans.Instance {
        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistance<?> df, double[][] means) {
            super(relation, df, means);
        }

        @Override
        protected int iterate(int iteration) {
            if (iteration > 1) {
                this.means = this.medians(this.clusters, this.means, (Relation<? extends NumberVector>)this.relation);
            }
            return this.assignToNearestCluster();
        }

        protected Clustering<MeanModel> buildMediansResult() {
            Clustering<MeanModel> result = new Clustering<MeanModel>();
            Metadata.of(result).setLongName("k-Medians Clustering");
            for (int i = 0; i < this.clusters.size(); ++i) {
                result.addToplevelCluster(new Cluster<MeanModel>((DBIDs)this.clusters.get(i), new MeanModel(this.means[i])));
            }
            return result;
        }

        protected double[][] medians(List<? extends DBIDs> clusters, double[][] medians, Relation<? extends NumberVector> relation) {
            int dim = medians[0].length;
            VectorUtil.SortDBIDsBySingleDimension sorter = new VectorUtil.SortDBIDsBySingleDimension(relation);
            double[][] newMedians = new double[this.k][];
            ArrayModifiableDBIDs list = DBIDUtil.newArray();
            DBIDArrayMIter it = list.iter();
            for (int i = 0; i < this.k; ++i) {
                DBIDs clu = clusters.get(i);
                if (clu.size() <= 0) {
                    newMedians[i] = medians[i];
                    continue;
                }
                list.clear().addDBIDs(clu);
                double[] mean = new double[dim];
                for (int d = 0; d < dim; ++d) {
                    sorter.setDimension(d);
                    mean[d] = ((NumberVector)relation.get((DBIDRef)it.seek(QuickSelectDBIDs.median((ArrayModifiableDBIDs)list, (Comparator)sorter)))).doubleValue(d);
                }
                newMedians[i] = mean;
            }
            return newMedians;
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

