/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans;

import elki.clustering.kmeans.AbstractKMeans;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.KMeansModel;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.logging.Logging;
import elki.utilities.Alias;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.documentation.Title;

@Title(value="k-Means (Lloyd/Forgy Algorithm)")
@References(value={@Reference(authors="S. Lloyd", title="Least squares quantization in PCM", booktitle="IEEE Transactions on Information Theory 28 (2): 129\u2013137.", url="https://doi.org/10.1109/TIT.1982.1056489", bibkey="DBLP:journals/tit/Lloyd82"), @Reference(authors="E. W. Forgy", title="Cluster analysis of multivariate data: efficiency versus interpretability of classifications", booktitle="Biometrics 21(3)", bibkey="journals/biometrics/Forgy65")})
@Alias(value={"lloyd", "forgy"})
public class LloydKMeans<V extends NumberVector>
extends AbstractKMeans<V, KMeansModel> {
    private static final Logging LOG = Logging.getLogger(LloydKMeans.class);

    public LloydKMeans(NumberVectorDistance<? super V> distance, int k, int maxiter, KMeansInitialization initializer) {
        super(distance, k, maxiter, initializer);
    }

    @Override
    public Clustering<KMeansModel> run(Relation<V> relation) {
        Instance instance = new Instance(relation, this.distance, this.initialMeans(relation));
        instance.run(this.maxiter);
        return instance.buildResult();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V extends NumberVector>
    extends AbstractKMeans.Par<V> {
        @Override
        public LloydKMeans<V> make() {
            return new LloydKMeans(this.distance, this.k, this.maxiter, this.initializer);
        }
    }

    protected static class Instance
    extends AbstractKMeans.Instance {
        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistance<?> df, double[][] means) {
            super(relation, df, means);
        }

        @Override
        protected int iterate(int iteration) {
            this.means = iteration == 1 ? this.means : AbstractKMeans.means(this.clusters, this.means, (Relation<? extends NumberVector>)this.relation);
            return this.assignToNearestCluster();
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

