/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans;

import elki.clustering.kmeans.AbstractKMeans;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.KMeansModel;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.logging.Logging;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import java.util.Arrays;

@Title(value="k-Means (MacQueen Algorithm)")
@Reference(authors="J. MacQueen", title="Some Methods for Classification and Analysis of Multivariate Observations", booktitle="5th Berkeley Symp. Math. Statist. Prob.", url="http://projecteuclid.org/euclid.bsmsp/1200512992", bibkey="conf/bsmsp/MacQueen67")
public class MacQueenKMeans<V extends NumberVector>
extends AbstractKMeans<V, KMeansModel> {
    private static final Logging LOG = Logging.getLogger(MacQueenKMeans.class);

    public MacQueenKMeans(NumberVectorDistance<? super V> distance, int k, int maxiter, KMeansInitialization initializer) {
        super(distance, k, maxiter, initializer);
    }

    @Override
    public Clustering<KMeansModel> run(Relation<V> relation) {
        Instance instance = new Instance(relation, this.distance, this.initialMeans(relation));
        instance.run(this.maxiter);
        return instance.buildResult();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V extends NumberVector>
    extends AbstractKMeans.Par<V> {
        @Override
        public MacQueenKMeans<V> make() {
            return new MacQueenKMeans(this.distance, this.k, this.maxiter, this.initializer);
        }
    }

    protected static class Instance
    extends AbstractKMeans.Instance {
        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistance<?> df, double[][] means) {
            super(relation, df, means);
        }

        @Override
        protected int iterate(int iteration) {
            int changed = 0;
            Arrays.fill(this.varsum, 0.0);
            DBIDIter iditer = this.relation.iterDBIDs();
            while (iditer.valid()) {
                double mindist = Double.POSITIVE_INFINITY;
                NumberVector fv = (NumberVector)this.relation.get((DBIDRef)iditer);
                int minIndex = 0;
                for (int i = 0; i < this.k; ++i) {
                    double dist = this.distance(fv, this.means[i]);
                    if (!(dist < mindist)) continue;
                    minIndex = i;
                    mindist = dist;
                }
                int n = minIndex;
                this.varsum[n] = this.varsum[n] + mindist;
                if (this.updateMeanAndAssignment(minIndex, fv, iditer)) {
                    ++changed;
                }
                iditer.advance();
            }
            return changed;
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }

        private boolean updateMeanAndAssignment(int minIndex, NumberVector fv, DBIDIter iditer) {
            int cur = this.assignment.intValue((DBIDRef)iditer);
            if (cur == minIndex) {
                return false;
            }
            ModifiableDBIDs curclus = (ModifiableDBIDs)this.clusters.get(minIndex);
            curclus.add((DBIDRef)iditer);
            AbstractKMeans.incrementalUpdateMean(this.means[minIndex], fv, curclus.size(), 1.0);
            if (cur >= 0) {
                ModifiableDBIDs ci = (ModifiableDBIDs)this.clusters.get(cur);
                ci.remove((DBIDRef)iditer);
                AbstractKMeans.incrementalUpdateMean(this.means[cur], fv, ci.size() + 1, -1.0);
            }
            this.assignment.putInt((DBIDRef)iditer, minIndex);
            return true;
        }
    }
}

