/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans;

import elki.clustering.kmeans.AbstractKMeans;
import elki.clustering.kmeans.ExponionKMeans;
import elki.clustering.kmeans.HamerlyKMeans;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.KMeansModel;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.logging.Logging;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;

@Reference(authors="C. Borgelt", title="Even Faster Exact k-Means Clustering", booktitle="Proc. 18th Int. Symp. Intelligent Data Analysis (IDA)", url="https://doi.org/10.1007/978-3-030-44584-3_8", bibkey="DBLP:conf/ida/Borgelt20")
@Priority(value=200)
public class ShallotKMeans<V extends NumberVector>
extends ExponionKMeans<V> {
    private static final Logging LOG = Logging.getLogger(ShallotKMeans.class);

    public ShallotKMeans(NumberVectorDistance<? super V> distance, int k, int maxiter, KMeansInitialization initializer, boolean varstat) {
        super(distance, k, maxiter, initializer, varstat);
    }

    @Override
    public Clustering<KMeansModel> run(Relation<V> relation) {
        Instance instance = new Instance(relation, this.distance, this.initialMeans(relation));
        instance.run(this.maxiter);
        return instance.buildResult(this.varstat, relation);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V extends NumberVector>
    extends HamerlyKMeans.Par<V> {
        @Override
        public ShallotKMeans<V> make() {
            return new ShallotKMeans(this.distance, this.k, this.maxiter, this.initializer, this.varstat);
        }
    }

    protected static class Instance
    extends ExponionKMeans.Instance {
        WritableIntegerDataStore second;

        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistance<?> df, double[][] means) {
            super(relation, df, means);
            this.second = DataStoreUtil.makeIntegerStorage((DBIDs)relation.getDBIDs(), (int)3, (int)-1);
        }

        @Override
        protected int initialAssignToNearestCluster() {
            assert (this.k == this.means.length);
            this.computeSquaredSeparation(this.cdist);
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                NumberVector fv = (NumberVector)this.relation.get((DBIDRef)it);
                double min1 = this.distance(fv, this.means[0]);
                double min2 = this.k > 1 ? this.distance(fv, this.means[1]) : min1;
                int minIdx = 0;
                int minId2 = 1;
                if (min2 < min1) {
                    double tmp = min1;
                    min1 = min2;
                    min2 = tmp;
                    minIdx = 1;
                    minId2 = 0;
                }
                for (int i = 2; i < this.k; ++i) {
                    if (!(min2 > this.cdist[minIdx][i])) continue;
                    double dist = this.distance(fv, this.means[i]);
                    if (dist < min1) {
                        minId2 = minIdx;
                        minIdx = i;
                        min2 = min1;
                        min1 = dist;
                        continue;
                    }
                    if (!(dist < min2)) continue;
                    minId2 = i;
                    min2 = dist;
                }
                ((ModifiableDBIDs)this.clusters.get(minIdx)).add((DBIDRef)it);
                this.assignment.putInt((DBIDRef)it, minIdx);
                AbstractKMeans.plusEquals(this.sums[minIdx], fv);
                this.upper.putDouble((DBIDRef)it, this.isSquared ? Math.sqrt(min1) : min1);
                this.lower.putDouble((DBIDRef)it, this.isSquared ? Math.sqrt(min2) : min2);
                this.second.putInt((DBIDRef)it, minId2);
                it.advance();
            }
            return this.relation.size();
        }

        @Override
        protected int assignToNearestCluster() {
            this.recomputeSeperation(this.sep, this.cdist);
            AbstractKMeans.nearestMeans(this.cdist, this.cnum);
            int changed = 0;
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                int orig = this.assignment.intValue((DBIDRef)it);
                double z = this.lower.doubleValue((DBIDRef)it);
                double so = this.sep[orig];
                double u = this.upper.doubleValue((DBIDRef)it);
                if (!(u <= z) && !(u <= so)) {
                    NumberVector fv = (NumberVector)this.relation.get((DBIDRef)it);
                    double curd2 = this.distance(fv, this.means[orig]);
                    u = this.isSquared ? Math.sqrt(curd2) : curd2;
                    this.upper.putDouble((DBIDRef)it, u);
                    if (!(u <= z || u <= so || this.cdist[orig][this.cnum[orig][0]] > u + 0.5 * so)) {
                        int c;
                        int osecn = this.second.intValue((DBIDRef)it);
                        double secd2 = this.distance(fv, this.means[osecn]);
                        int ref = orig;
                        int secn = osecn;
                        if (secd2 < curd2) {
                            double tmp = secd2;
                            secd2 = curd2;
                            curd2 = tmp;
                            ref = secn;
                            secn = orig;
                            u = this.isSquared ? Math.sqrt(curd2) : curd2;
                        }
                        double lp = u + (this.isSquared ? Math.sqrt(secd2) : secd2);
                        double lv = 2.0 * (u + this.cdist[ref][this.cnum[ref][0]]);
                        double l = lp < lv ? lp : lv;
                        double rhalf = Math.min(u + 0.5 * this.sep[ref], 0.5 * (u + l));
                        double min1 = curd2;
                        double min2 = l * l;
                        int cur = ref;
                        int minId2 = lp < lv ? secn : this.cnum[ref][0];
                        for (int i = 0; i < this.k - 1 && !(this.cdist[ref][c = this.cnum[ref][i]] > rhalf); ++i) {
                            double dist;
                            double d = dist = c == secn ? secd2 : this.distance(fv, this.means[c]);
                            if (dist < min1) {
                                minId2 = cur;
                                cur = c;
                                min2 = min1;
                                min1 = dist;
                                if (!(min1 < l * l)) continue;
                                l = this.isSquared ? Math.sqrt(min2) : min2;
                                rhalf = Math.min(rhalf, 0.5 * (u + l));
                                continue;
                            }
                            if (!(dist < min2)) continue;
                            minId2 = c;
                            min2 = dist;
                            l = this.isSquared ? Math.sqrt(min2) : min2;
                            rhalf = Math.min(rhalf, 0.5 * (u + l));
                        }
                        if (cur != orig) {
                            ((ModifiableDBIDs)this.clusters.get(cur)).add((DBIDRef)it);
                            ((ModifiableDBIDs)this.clusters.get(orig)).remove((DBIDRef)it);
                            this.assignment.putInt((DBIDRef)it, cur);
                            AbstractKMeans.plusMinusEquals(this.sums[cur], this.sums[orig], fv);
                            ++changed;
                            this.upper.putDouble((DBIDRef)it, min1 == curd2 ? u : (this.isSquared ? Math.sqrt(min1) : min1));
                        }
                        this.lower.putDouble((DBIDRef)it, l);
                        if (osecn != minId2) {
                            this.second.putInt((DBIDRef)it, minId2);
                        }
                    }
                }
                it.advance();
            }
            return changed;
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

