/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans;

import elki.clustering.kmeans.AbstractKMeans;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.KMeansModel;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.logging.Logging;
import elki.math.linearalgebra.VMath;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.parameterization.Parameterization;

@Reference(authors="J. Newling", title="Fast k-means with accurate bounds", booktitle="Proc. 33nd Int. Conf. on Machine Learning, ICML 2016", url="http://jmlr.org/proceedings/papers/v48/newling16.html", bibkey="DBLP:conf/icml/NewlingF16")
public class SimplifiedElkanKMeans<V extends NumberVector>
extends AbstractKMeans<V, KMeansModel> {
    private static final Logging LOG = Logging.getLogger(SimplifiedElkanKMeans.class);
    protected boolean varstat = false;

    public SimplifiedElkanKMeans(NumberVectorDistance<? super V> distance, int k, int maxiter, KMeansInitialization initializer, boolean varstat) {
        super(distance, k, maxiter, initializer);
        this.varstat = varstat;
    }

    @Override
    public Clustering<KMeansModel> run(Relation<V> relation) {
        Instance instance = new Instance(relation, this.distance, this.initialMeans(relation));
        instance.run(this.maxiter);
        return instance.buildResult(this.varstat, relation);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V extends NumberVector>
    extends AbstractKMeans.Par<V> {
        @Override
        protected boolean needsMetric() {
            return true;
        }

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            super.getParameterVarstat(config);
        }

        @Override
        public SimplifiedElkanKMeans<V> make() {
            return new SimplifiedElkanKMeans(this.distance, this.k, this.maxiter, this.initializer, this.varstat);
        }
    }

    protected static class Instance
    extends AbstractKMeans.Instance {
        double[][] sums;
        double[][] newmeans;
        WritableDoubleDataStore upper;
        WritableDataStore<double[]> lower;
        double[] sep;

        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistance<?> df, double[][] means) {
            super(relation, df, means);
            this.upper = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)3, (double)Double.POSITIVE_INFINITY);
            this.lower = DataStoreUtil.makeStorage((DBIDs)relation.getDBIDs(), (int)3, double[].class);
            DBIDIter it = relation.iterDBIDs();
            while (it.valid()) {
                this.lower.put((DBIDRef)it, (Object)new double[this.k]);
                it.advance();
            }
            int dim = means[0].length;
            this.sums = new double[this.k][dim];
            this.newmeans = new double[this.k][dim];
            this.sep = new double[this.k];
        }

        @Override
        protected int iterate(int iteration) {
            if (iteration == 1) {
                return this.initialAssignToNearestCluster();
            }
            this.meansFromSums(this.newmeans, this.sums, this.means);
            this.movedDistance(this.means, this.newmeans, this.sep);
            this.updateBounds(this.sep);
            this.copyMeans(this.newmeans, this.means);
            return this.assignToNearestCluster();
        }

        protected int initialAssignToNearestCluster() {
            assert (this.k == this.means.length);
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                NumberVector fv = (NumberVector)this.relation.get((DBIDRef)it);
                double[] l = (double[])this.lower.get((DBIDRef)it);
                double best = l[0] = this.sqrtdistance(fv, this.means[0]);
                int minIndex = 0;
                for (int j = 1; j < this.k; ++j) {
                    l[j] = this.sqrtdistance(fv, this.means[j]);
                    double dist = l[j];
                    if (!(dist < best)) continue;
                    minIndex = j;
                    best = dist;
                }
                ((ModifiableDBIDs)this.clusters.get(minIndex)).add((DBIDRef)it);
                this.assignment.putInt((DBIDRef)it, minIndex);
                AbstractKMeans.plusEquals(this.sums[minIndex], fv);
                this.upper.putDouble((DBIDRef)it, best);
                it.advance();
            }
            return this.relation.size();
        }

        @Override
        protected int assignToNearestCluster() {
            int changed = 0;
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                int orig = this.assignment.intValue((DBIDRef)it);
                double u = this.upper.doubleValue((DBIDRef)it);
                boolean recompute_u = true;
                NumberVector fv = (NumberVector)this.relation.get((DBIDRef)it);
                double[] l = (double[])this.lower.get((DBIDRef)it);
                int cur = orig;
                for (int j = 0; j < this.k; ++j) {
                    double dist;
                    if (orig == j || u <= l[j]) continue;
                    if (recompute_u) {
                        u = this.sqrtdistance(fv, this.means[cur]);
                        this.upper.putDouble((DBIDRef)it, u);
                        recompute_u = false;
                        if (u <= l[j]) continue;
                    }
                    if (!((dist = (l[j] = this.sqrtdistance(fv, this.means[j]))) < u)) continue;
                    cur = j;
                    u = dist;
                }
                if (cur != orig) {
                    ((ModifiableDBIDs)this.clusters.get(cur)).add((DBIDRef)it);
                    ((ModifiableDBIDs)this.clusters.get(orig)).remove((DBIDRef)it);
                    this.assignment.putInt((DBIDRef)it, cur);
                    AbstractKMeans.plusMinusEquals(this.sums[cur], this.sums[orig], fv);
                    ++changed;
                    this.upper.putDouble((DBIDRef)it, u);
                }
                it.advance();
            }
            return changed;
        }

        protected void updateBounds(double[] move) {
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                this.upper.increment((DBIDRef)it, move[this.assignment.intValue((DBIDRef)it)]);
                VMath.minusEquals((double[])((double[])this.lower.get((DBIDRef)it)), (double[])move);
                it.advance();
            }
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

