/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans;

import elki.clustering.kmeans.AbstractKMeans;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.KMeansModel;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.logging.Logging;
import elki.utilities.optionhandling.parameterization.Parameterization;

public class SingleAssignmentKMeans<V extends NumberVector>
extends AbstractKMeans<V, KMeansModel> {
    private static final Logging LOG = Logging.getLogger(SingleAssignmentKMeans.class);

    public SingleAssignmentKMeans(NumberVectorDistance<? super V> distance, int k, KMeansInitialization initializer) {
        super(distance, k, 1, initializer);
    }

    @Override
    public Clustering<KMeansModel> run(Relation<V> relation) {
        Instance instance = new Instance(relation, this.distance, this.initialMeans(relation));
        instance.run(1);
        return instance.buildResult();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V extends NumberVector>
    extends AbstractKMeans.Par<V> {
        @Override
        public void configure(Parameterization config) {
            this.getParameterDistance(config);
            this.getParameterK(config);
            this.getParameterInitialization(config);
        }

        @Override
        public SingleAssignmentKMeans<V> make() {
            return new SingleAssignmentKMeans(this.distance, this.k, this.initializer);
        }
    }

    protected static class Instance
    extends AbstractKMeans.Instance {
        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistance<?> df, double[][] means) {
            super(relation, df, means);
        }

        @Override
        protected int iterate(int iteration) {
            assert (iteration == 1);
            return -this.assignToNearestCluster();
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

