/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans;

import elki.clustering.kmeans.AbstractKMeans;
import elki.clustering.kmeans.CompareMeans;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.KMeansModel;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.logging.Logging;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import java.util.Arrays;

@Title(value="Sort-Means")
@Reference(authors="S. J. Phillips", title="Acceleration of k-means and related clustering algorithms", booktitle="Proc. 4th Int. Workshop on Algorithm Engineering and Experiments (ALENEX 2002)", url="https://doi.org/10.1007/3-540-45643-0_13", bibkey="DBLP:conf/alenex/Phillips02")
public class SortMeans<V extends NumberVector>
extends CompareMeans<V> {
    private static final Logging LOG = Logging.getLogger(SortMeans.class);

    public SortMeans(NumberVectorDistance<? super V> distance, int k, int maxiter, KMeansInitialization initializer) {
        super(distance, k, maxiter, initializer);
    }

    @Override
    public Clustering<KMeansModel> run(Relation<V> relation) {
        Instance instance = new Instance(relation, this.distance, this.initialMeans(relation));
        instance.run(this.maxiter);
        return instance.buildResult();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V extends NumberVector>
    extends AbstractKMeans.Par<V> {
        @Override
        protected boolean needsMetric() {
            return true;
        }

        @Override
        public SortMeans<V> make() {
            return new SortMeans(this.distance, this.k, this.maxiter, this.initializer);
        }
    }

    protected static class Instance
    extends CompareMeans.Instance {
        int[][] cnum;

        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistance<?> df, double[][] means) {
            super(relation, df, means);
            this.cnum = new int[this.k][this.k - 1];
        }

        @Override
        protected int assignToNearestCluster() {
            AbstractKMeans.nearestMeans(this.cdist, this.cnum);
            int changed = 0;
            Arrays.fill(this.varsum, 0.0);
            for (ModifiableDBIDs cluster : this.clusters) {
                cluster.clear();
            }
            double mult = this.isSquared ? 4.0 : 2.0;
            DBIDIter iditer = this.relation.iterDBIDs();
            while (iditer.valid()) {
                int cur = this.assignment.intValue((DBIDRef)iditer);
                int ini = cur >= 0 ? cur : 0;
                NumberVector fv = (NumberVector)this.relation.get((DBIDRef)iditer);
                double mindist = this.distance(fv, this.means[ini]);
                double threshold = mult * mindist;
                int minIndex = ini;
                for (int i : this.cnum[ini]) {
                    if (this.cdist[minIndex][i] >= threshold) break;
                    double dist = this.distance(fv, this.means[i]);
                    if (!(dist < mindist)) continue;
                    minIndex = i;
                    mindist = dist;
                }
                int n = minIndex;
                this.varsum[n] = this.varsum[n] + mindist;
                ((ModifiableDBIDs)this.clusters.get(minIndex)).add((DBIDRef)iditer);
                if (this.assignment.putInt((DBIDRef)iditer, minIndex) != minIndex) {
                    ++changed;
                }
                iditer.advance();
            }
            return changed;
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

