/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.initialization;

import elki.clustering.kmeans.initialization.KMC2;
import elki.data.NumberVector;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.logging.Logging;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.random.RandomFactory;

@Title(value="AFK-MC\u00b2")
@Reference(authors="O. Bachem, M. Lucic, S. H. Hassani, A. Krause", title="Fast and Provably Good Seedings for k-Means", booktitle="Neural Information Processing Systems 2016", url="https://proceedings.neurips.cc/paper/2016/hash/d67d8ab4f4c10bf22aa353e27879133c-Abstract.html", bibkey="DBLP:conf/nips/BachemLH016")
public class AFKMC2
extends KMC2 {
    private static final Logging LOG = Logging.getLogger(AFKMC2.class);

    public AFKMC2(int m, RandomFactory rnd) {
        super(m, rnd);
    }

    @Override
    public double[][] chooseInitialMeans(Relation<? extends NumberVector> relation, int k, NumberVectorDistance<?> distance) {
        if (relation.size() < k) {
            throw new IllegalArgumentException("Cannot choose k=" + k + " means from N=" + relation.size() + " < k objects.");
        }
        return new Instance(relation, distance, this.m, this.rnd).run(k);
    }

    public static class Par
    extends KMC2.Par {
        @Override
        public AFKMC2 make() {
            return new AFKMC2(this.m, this.rnd);
        }
    }

    protected static class Instance
    extends KMC2.Instance {
        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistance<?> distance, int m, RandomFactory rnd) {
            super(relation, distance, m, rnd);
        }

        @Override
        protected DBIDRef sample(double weightsum) {
            DBIDIter it;
            int n = this.relation.size();
            while (true) {
                if (weightsum > Double.MAX_VALUE) {
                    throw new IllegalStateException("Could not choose a reasonable mean - too many data points, too large distance sum?");
                }
                if (weightsum < Double.MIN_NORMAL) {
                    LOG.warning((CharSequence)"Could not choose a reasonable mean - to few unique data points?");
                }
                double r = this.random.nextDouble() * weightsum * 2.0;
                double bias = weightsum / (double)n;
                it = this.relation.iterDBIDs();
                while (it.valid()) {
                    double d;
                    r -= this.weights.doubleValue((DBIDRef)it) + bias;
                    if (d <= 0.0) break;
                    it.advance();
                }
                if (it.valid()) break;
                weightsum -= r;
            }
            return it;
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

