/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.initialization;

import elki.clustering.kmeans.initialization.AbstractKMeansInitialization;
import elki.clustering.kmedoids.initialization.KMedoidsInitialization;
import elki.data.NumberVector;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.random.RandomFactory;

public class FarthestPoints<O>
extends AbstractKMeansInitialization
implements KMedoidsInitialization<O> {
    boolean dropfirst = true;

    public FarthestPoints(RandomFactory rnd, boolean dropfirst) {
        super(rnd);
        this.dropfirst = dropfirst;
    }

    @Override
    public double[][] chooseInitialMeans(Relation<? extends NumberVector> relation, int k, NumberVectorDistance<?> distance) {
        int i;
        if (relation.size() < k) {
            throw new IllegalArgumentException("Cannot choose k=" + k + " means from N=" + relation.size() + " < k objects.");
        }
        DBIDs ids = relation.getDBIDs();
        WritableDoubleDataStore store = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3, (double)Double.POSITIVE_INFINITY);
        double[][] means = new double[k][];
        DBIDVar first = DBIDUtil.randomSample((DBIDs)ids, (RandomFactory)this.rnd);
        NumberVector prevmean = (NumberVector)relation.get((DBIDRef)first);
        if (!this.dropfirst) {
            means[0] = prevmean.toArray();
        }
        DBIDVar best = DBIDUtil.newVar((DBIDRef)first);
        int n = i = this.dropfirst ? 0 : 1;
        while (i < k) {
            double maxdist = Double.NEGATIVE_INFINITY;
            DBIDIter it = ids.iter();
            while (it.valid()) {
                double prev = store.doubleValue((DBIDRef)it);
                if (prev == prev) {
                    double val = Math.min(prev, distance.distance(prevmean, (NumberVector)relation.get((DBIDRef)it)));
                    if (i > 0) {
                        store.putDouble((DBIDRef)it, val);
                    }
                    if (val > maxdist) {
                        maxdist = val;
                        best.set((DBIDRef)it);
                    }
                }
                it.advance();
            }
            store.putDouble((DBIDRef)best, Double.NaN);
            prevmean = (NumberVector)relation.get((DBIDRef)best);
            means[i] = prevmean.toArray();
            ++i;
        }
        store.destroy();
        return means;
    }

    @Override
    public DBIDs chooseInitialMedoids(int k, DBIDs ids, DistanceQuery<? super O> distQ) {
        int i;
        WritableDoubleDataStore store = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3, (double)Double.POSITIVE_INFINITY);
        ArrayModifiableDBIDs means = DBIDUtil.newArray((int)k);
        DBIDVar prevmean = DBIDUtil.newVar((DBIDRef)DBIDUtil.randomSample((DBIDs)ids, (RandomFactory)this.rnd));
        DBIDVar best = DBIDUtil.newVar((DBIDRef)prevmean);
        means.add((DBIDRef)prevmean);
        int n = i = this.dropfirst ? 0 : 1;
        while (i < k) {
            double maxdist = Double.NEGATIVE_INFINITY;
            DBIDIter it = ids.iter();
            while (it.valid()) {
                double prev = store.doubleValue((DBIDRef)it);
                if (prev == prev) {
                    double val = Math.min(prev, distQ.distance((DBIDRef)prevmean, (DBIDRef)it));
                    if (i > 0) {
                        store.putDouble((DBIDRef)it, val);
                    }
                    if (val > maxdist) {
                        maxdist = val;
                        best.set((DBIDRef)it);
                    }
                }
                it.advance();
            }
            if (i == 0) {
                means.clear();
            }
            store.putDouble((DBIDRef)best, Double.NaN);
            prevmean.set((DBIDRef)best);
            means.add((DBIDRef)best);
            ++i;
        }
        store.destroy();
        return means;
    }

    public static class Par<O>
    extends AbstractKMeansInitialization.Par {
        public static final OptionID KEEPFIRST_ID = new OptionID("farthest.keepfirst", "Keep the first object chosen (which is chosen randomly) for the farthest points heuristic.");
        protected boolean keepfirst = false;

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            new Flag(KEEPFIRST_ID).grab(config, x -> {
                this.keepfirst = x;
            });
        }

        public FarthestPoints<O> make() {
            return new FarthestPoints(this.rnd, !this.keepfirst);
        }
    }
}

