/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.initialization;

import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.clustering.kmedoids.initialization.KMedoidsInitialization;
import elki.data.NumberVector;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;

@Reference(authors="J. MacQueen", title="Some Methods for Classification and Analysis of Multivariate Observations", booktitle="5th Berkeley Symp. Math. Statist. Prob.", url="http://projecteuclid.org/euclid.bsmsp/1200512992", bibkey="conf/bsmsp/MacQueen67")
public class FirstK<O>
implements KMeansInitialization,
KMedoidsInitialization<O> {
    @Override
    public double[][] chooseInitialMeans(Relation<? extends NumberVector> relation, int k, NumberVectorDistance<?> distance) {
        DBIDIter iter = relation.iterDBIDs();
        double[][] means = new double[k][];
        for (int i = 0; i < k && iter.valid(); ++i) {
            means[i] = ((NumberVector)relation.get((DBIDRef)iter)).toArray();
            iter.advance();
        }
        return means;
    }

    @Override
    public DBIDs chooseInitialMedoids(int k, DBIDs ids, DistanceQuery<? super O> distance) {
        DBIDIter iter = ids.iter();
        ArrayModifiableDBIDs means = DBIDUtil.newArray((int)k);
        for (int i = 0; i < k && iter.valid(); ++i) {
            means.add((DBIDRef)iter);
            iter.advance();
        }
        return means;
    }

    public static class Par<V extends NumberVector>
    implements Parameterizer {
        public FirstK<V> make() {
            return new FirstK();
        }
    }
}

