/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.initialization;

import elki.clustering.kmeans.initialization.AbstractKMeansInitialization;
import elki.clustering.kmeans.initialization.KMeansPlusPlus;
import elki.data.DoubleVector;
import elki.data.NumberVector;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.logging.Logging;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.math.MeanVariance;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.random.RandomFactory;
import java.util.ArrayList;

@References(value={@Reference(authors="R. Ostrovsky, Y. Rabani, L. J. Schulman, C. Swamy", title="The effectiveness of Lloyd-type methods for the k-means problem", booktitle="Symposium on Foundations of Computer Science (FOCS)", url="https://doi.org/10.1109/FOCS.2006.75", bibkey="DBLP:conf/focs/OstrovskyRSS06"), @Reference(authors="R. Ostrovsky, Y. Rabani, L. J. Schulman, C. Swamy", title="The effectiveness of Lloyd-type methods for the k-means problem", booktitle="Journal of the ACM 59(6)", url="https://doi.org/10.1145/2395116.2395117", bibkey="DBLP:journals/jacm/OstrovskyRSS12")})
public class Ostrovsky
extends AbstractKMeansInitialization {
    private static final Logging LOG = Logging.getLogger(Ostrovsky.class);

    public Ostrovsky(RandomFactory rnd) {
        super(rnd);
    }

    @Override
    public double[][] chooseInitialMeans(Relation<? extends NumberVector> relation, int k, NumberVectorDistance<?> distance) {
        if (relation.size() < k) {
            throw new IllegalArgumentException("Cannot choose k=" + k + " means from N=" + relation.size() + " < k objects.");
        }
        if (!(distance instanceof SquaredEuclideanDistance)) {
            throw new IllegalArgumentException("This initialization works ONLY with squared Euclidean distances for correctness.");
        }
        return new NumberVectorInstance(relation, distance, this.rnd).run(relation, k);
    }

    public static class Par
    extends AbstractKMeansInitialization.Par {
        public Ostrovsky make() {
            return new Ostrovsky(this.rnd);
        }
    }

    protected class NumberVectorInstance
    extends KMeansPlusPlus.NumberVectorInstance {
        public NumberVectorInstance(Relation<? extends NumberVector> relation, NumberVectorDistance<?> distance, RandomFactory rnd) {
            super(relation, distance, rnd);
        }

        public double[][] run(Relation<? extends NumberVector> relation, int k) {
            MeanVariance[] mv = MeanVariance.of(relation);
            double[] center = new double[mv.length];
            double total = 0.0;
            for (int d = 0; d < mv.length; ++d) {
                center[d] = mv[d].getMean();
                total += mv[d].getSumOfSquares();
            }
            double bias = total / (double)this.ids.size();
            DoubleVector cnv = DoubleVector.wrap((double[])center);
            ArrayList<NumberVector> means = new ArrayList<NumberVector>(k);
            NumberVector firstvec = null;
            double r = this.random.nextDouble() * total * 2.0;
            DBIDIter it = this.ids.iter();
            while (it.valid()) {
                double d;
                ++this.diststat;
                firstvec = (NumberVector)relation.get((DBIDRef)it);
                double firstdist = this.distance.distance((NumberVector)cnv, firstvec);
                r -= bias + firstdist;
                if (d <= 0.0) break;
                it.advance();
            }
            means.add(firstvec);
            this.chooseRemaining(k, means, this.initialWeights(firstvec));
            this.weights.destroy();
            LOG.statistics((Statistic)new LongStatistic(KMeansPlusPlus.class.getName() + ".distance-computations", this.diststat));
            return AbstractKMeansInitialization.unboxVectors(means);
        }
    }
}

