/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.initialization;

import elki.clustering.kmeans.initialization.AbstractKMeansInitialization;
import elki.data.Cluster;
import elki.data.NumberVector;
import elki.data.model.MeanModel;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleArrayListParameter;
import java.util.List;

public class Predefined
extends AbstractKMeansInitialization {
    double[][] initialMeans;

    public Predefined(double[][] initialMeans) {
        super(null);
        this.initialMeans = initialMeans;
    }

    public void setInitialMeans(List<double[]> initialMeans) {
        this.setInitialMeans(initialMeans);
    }

    public void setInitialClusters(List<? extends Cluster<? extends MeanModel>> initialMeans) {
        double[][] vecs = new double[initialMeans.size()][];
        for (int i = 0; i < vecs.length; ++i) {
            vecs[i] = initialMeans.get(i).getModel().getMean();
        }
        this.initialMeans = vecs;
    }

    public void setInitialMeans(double[][] initialMeans) {
        double[][] vecs = (double[][])initialMeans.clone();
        this.initialMeans = vecs;
    }

    @Override
    public double[][] chooseInitialMeans(Relation<? extends NumberVector> relation, int k, NumberVectorDistance<?> distance) {
        if (k != this.initialMeans.length) {
            throw new AbortException("Predefined initial means contained " + this.initialMeans.length + " means, algorithm requested " + k + " means instead.");
        }
        return this.initialMeans;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID INITIAL_MEANS = new OptionID("kmeans.means", "Initial means for k-means.");
        protected double[][] initialMeans;

        public void configure(Parameterization config) {
            new DoubleArrayListParameter(INITIAL_MEANS).grab(config, x -> {
                this.initialMeans = (double[][])x.toArray((T[])new double[0][]);
            });
        }

        public Predefined make() {
            return new Predefined(this.initialMeans);
        }
    }
}

