/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.initialization;

import elki.clustering.kmeans.initialization.AbstractKMeansInitialization;
import elki.data.NumberVector;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.math.MeanVariance;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import elki.utilities.random.RandomFactory;
import java.util.Random;

@Priority(value=-101)
@Reference(authors="R. C. Jancey", title="Multidimensional group analysis", booktitle="Australian Journal of Botany 14(1)", url="https://doi.org/10.1071/BT9660127", bibkey="doi:10.1071/BT9660127")
public class RandomNormalGenerated
extends AbstractKMeansInitialization {
    public RandomNormalGenerated(RandomFactory rnd) {
        super(rnd);
    }

    @Override
    public double[][] chooseInitialMeans(Relation<? extends NumberVector> relation, int k, NumberVectorDistance<?> distance) {
        MeanVariance[] mvs = MeanVariance.of(relation);
        int dim = mvs.length;
        double[] min = new double[dim];
        double[] scale = new double[dim];
        for (int d = 0; d < dim; ++d) {
            min[d] = mvs[d].getMean();
            scale[d] = mvs[d].getSampleStddev();
        }
        double[][] means = new double[k][dim];
        Random random = this.rnd.getSingleThreadedRandom();
        for (int i = 0; i < k; ++i) {
            double[] r = means[i];
            for (int d = 0; d < dim; ++d) {
                r[d] = scale[d] * random.nextGaussian() + min[d];
            }
        }
        return means;
    }

    public static class Par
    extends AbstractKMeansInitialization.Par {
        public RandomNormalGenerated make() {
            return new RandomNormalGenerated(this.rnd);
        }
    }
}

