/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.initialization;

import elki.clustering.kmeans.initialization.AbstractKMeansInitialization;
import elki.data.NumberVector;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.distance.NumberVectorDistance;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import elki.utilities.random.RandomFactory;
import java.util.Random;

@Priority(value=-101)
@Reference(authors="R. C. Jancey", title="Multidimensional group analysis", booktitle="Australian Journal of Botany 14(1)", url="https://doi.org/10.1071/BT9660127", bibkey="doi:10.1071/BT9660127")
public class RandomUniformGenerated
extends AbstractKMeansInitialization {
    public RandomUniformGenerated(RandomFactory rnd) {
        super(rnd);
    }

    @Override
    public double[][] chooseInitialMeans(Relation<? extends NumberVector> relation, int k, NumberVectorDistance<?> distance) {
        double[][] minmax = RelationUtil.computeMinMax(relation);
        int dim = minmax[0].length;
        double[] min = minmax[0];
        double[] scale = minmax[1];
        for (int d = 0; d < dim; ++d) {
            scale[d] = scale[d] - min[d];
        }
        double[][] means = new double[k][];
        Random random = this.rnd.getSingleThreadedRandom();
        for (int i = 0; i < k; ++i) {
            double[] r = new double[dim];
            for (int d = 0; d < dim; ++d) {
                r[d] = min[d] + scale[d] * random.nextDouble();
            }
            means[i] = r;
        }
        return means;
    }

    public static class Par
    extends AbstractKMeansInitialization.Par {
        public RandomUniformGenerated make() {
            return new RandomUniformGenerated(this.rnd);
        }
    }
}

