/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.initialization;

import elki.clustering.kmeans.initialization.AbstractKMeansInitialization;
import elki.clustering.kmedoids.initialization.KMedoidsInitialization;
import elki.data.NumberVector;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.random.RandomFactory;

@References(value={@Reference(authors="D. J. McRae", title="MIKCA: A FORTRAN IV Iterative K-Means Cluster Analysis Program", booktitle="Behavioral Science 16(4)", bibkey="journals/misc/McRae71"), @Reference(authors="E. W. Forgy", title="Cluster analysis of multivariate data: efficiency versus interpretability of classifications", booktitle="Biometrics 21(3)", bibkey="journals/biometrics/Forgy65"), @Reference(authors="M. R. Anderberg", title="Nonhierarchical Clustering Methods", booktitle="Cluster Analysis for Applications", bibkey="books/academic/Anderberg73/Ch7")})
public class RandomlyChosen<O>
extends AbstractKMeansInitialization
implements KMedoidsInitialization<O> {
    public RandomlyChosen(RandomFactory rnd) {
        super(rnd);
    }

    @Override
    public double[][] chooseInitialMeans(Relation<? extends NumberVector> relation, int k, NumberVectorDistance<?> distance) {
        if (relation.size() < k) {
            throw new IllegalArgumentException("Cannot choose k=" + k + " means from N=" + relation.size() + " < k objects.");
        }
        ModifiableDBIDs ids = DBIDUtil.randomSample((DBIDs)relation.getDBIDs(), (int)k, (RandomFactory)this.rnd);
        double[][] means = new double[k][];
        DBIDIter iter = ids.iter();
        for (int i = 0; i < k; ++i) {
            means[i] = ((NumberVector)relation.get((DBIDRef)iter)).toArray();
            iter.advance();
        }
        return means;
    }

    @Override
    public DBIDs chooseInitialMedoids(int k, DBIDs ids, DistanceQuery<? super O> distance) {
        return DBIDUtil.randomSample((DBIDs)ids, (int)k, (RandomFactory)this.rnd);
    }

    public static class Par<V>
    extends AbstractKMeansInitialization.Par {
        public RandomlyChosen<V> make() {
            return new RandomlyChosen(this.rnd);
        }
    }
}

