/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.initialization.betula;

import elki.clustering.kmeans.initialization.betula.AbstractCFKMeansInitialization;
import elki.clustering.kmeans.initialization.betula.CFInitWeight;
import elki.clustering.kmeans.initialization.betula.SquaredEuclideanWeight;
import elki.index.tree.betula.CFTree;
import elki.index.tree.betula.features.AsClusterFeature;
import elki.index.tree.betula.features.ClusterFeature;
import elki.utilities.Alias;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.random.RandomFactory;
import java.util.List;
import java.util.Random;

@Alias(value={"leaves"})
@Reference(authors="Andreas Lang and Erich Schubert", title="BETULA: Fast Clustering of Large Data with Improved BIRCH CF-Trees", booktitle="Information Systems", url="https://doi.org/10.1016/j.is.2021.101918", bibkey="DBLP:journals/is/LangS22")
public class CFKPlusPlusLeaves
extends AbstractCFKMeansInitialization {
    protected CFInitWeight distance;
    protected boolean firstUniform;

    public CFKPlusPlusLeaves(CFInitWeight dist, boolean firstUniform, RandomFactory rf) {
        super(rf);
        this.distance = dist;
        this.firstUniform = firstUniform;
    }

    @Override
    public double[][] chooseInitialMeans(CFTree<?> tree, List<? extends ClusterFeature> cfs, int k) {
        return this.run(tree, cfs, k);
    }

    public double[][] run(CFTree<?> tree, List<? extends ClusterFeature> cfs, int k) {
        Random rnd = this.rf.getSingleThreadedRandom();
        double[][] means = new double[k][];
        ClusterFeature first = this.firstUniform ? cfs.get(rnd.nextInt(cfs.size())).getCF() : this.sampleFirst((ClusterFeature)tree.getRoot().getCF(), (List<? extends AsClusterFeature>)cfs, rnd);
        means[0] = first.toArray();
        double[] weights = new double[cfs.size()];
        double weightsum = this.initialWeights(first, cfs, weights);
        for (int m = 1; m < k; ++m) {
            int i;
            if (weightsum > Double.MAX_VALUE) {
                throw new IllegalStateException("Could not choose a reasonable mean - too many data points, too large distance sum?");
            }
            double r = rnd.nextDouble() * weightsum;
            for (i = 0; i < cfs.size(); ++i) {
                double d;
                r -= weights[i];
                if (d <= 0.0) break;
            }
            if (i >= cfs.size()) {
                weightsum -= r;
                continue;
            }
            ClusterFeature cfi = cfs.get(i).getCF();
            means[m] = cfi.toArray();
            if (m >= k - 1) continue;
            weights[i] = 0.0;
            weightsum = this.updateWeights(cfi, cfs, weights);
        }
        return means;
    }

    /*
     * WARNING - void declaration
     */
    private ClusterFeature sampleFirst(ClusterFeature root, List<? extends AsClusterFeature> cfs, Random rnd) {
        double weightsum = 0.0;
        double[] tmpWeight = new double[cfs.size()];
        int i = 0;
        for (AsClusterFeature asClusterFeature : cfs) {
            int n = i++;
            double d = this.distance.squaredWeight(root, asClusterFeature.getCF());
            tmpWeight[n] = d;
            weightsum += d;
        }
        while (true) {
            void var9_11;
            double r = rnd.nextDouble() * weightsum;
            boolean bl = false;
            while (var9_11 < tmpWeight.length) {
                double d;
                r -= tmpWeight[var9_11];
                if (d <= 0.0) {
                    return cfs.get((int)var9_11).getCF();
                }
                ++var9_11;
            }
            weightsum -= r;
        }
    }

    private double initialWeights(ClusterFeature first, List<? extends AsClusterFeature> cfs, double[] weights) {
        double weightsum = 0.0;
        int i = 0;
        for (AsClusterFeature asClusterFeature : cfs) {
            int n = i++;
            double d = this.distance.squaredWeight(first, asClusterFeature.getCF());
            weights[n] = d;
            weightsum += d;
        }
        return weightsum;
    }

    private double updateWeights(ClusterFeature latest, List<? extends AsClusterFeature> cfs, double[] weights) {
        double weightsum = 0.0;
        int i = -1;
        for (AsClusterFeature asClusterFeature : cfs) {
            double weight;
            if ((weight = weights[++i]) <= 0.0) continue;
            double newweight = this.distance.squaredWeight(latest, asClusterFeature.getCF());
            weightsum += newweight < weight ? newweight : weight;
        }
        return weightsum;
    }

    public static class Par
    extends AbstractCFKMeansInitialization.Par {
        public static final OptionID KMPP_DISTANCE_ID = new OptionID("kmeans.distance", "Distance to use for kmeans++ criterion");
        public static final OptionID FIRST_UNIFORM_ID = new OptionID("kmpp.first-uniform", "Choose the first center uniformly from the cluster features.");
        CFInitWeight dist = null;
        boolean firstUniform = false;

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            new ObjectParameter(KMPP_DISTANCE_ID, CFInitWeight.class, SquaredEuclideanWeight.class).grab(config, x -> {
                this.dist = x;
            });
            new Flag(FIRST_UNIFORM_ID).grab(config, x -> {
                this.firstUniform = x;
            });
        }

        public CFKPlusPlusLeaves make() {
            return new CFKPlusPlusLeaves(this.dist, this.firstUniform, this.rnd);
        }
    }
}

