/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.initialization.betula;

import elki.clustering.kmeans.initialization.betula.AbstractCFKMeansInitialization;
import elki.clustering.kmeans.initialization.betula.CFInitWeight;
import elki.clustering.kmeans.initialization.betula.CFKPlusPlusLeaves;
import elki.clustering.kmeans.initialization.betula.VarianceWeight;
import elki.index.tree.betula.CFNode;
import elki.index.tree.betula.CFTree;
import elki.index.tree.betula.features.AsClusterFeature;
import elki.index.tree.betula.features.ClusterFeature;
import elki.utilities.Alias;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.jafama.FastMath;

@Alias(value={"tree"})
@Reference(authors="Andreas Lang and Erich Schubert", title="BETULA: Fast Clustering of Large Data with Improved BIRCH CF-Trees", booktitle="Information Systems", url="https://doi.org/10.1016/j.is.2021.101918", bibkey="DBLP:journals/is/LangS22")
public class CFKPlusPlusTree
extends AbstractCFKMeansInitialization {
    CFInitWeight dist = null;
    boolean firstUniform = false;
    int maxdepth = -1;

    public CFKPlusPlusTree(CFInitWeight dist, boolean firstUniform, int maxdepth, RandomFactory rf) {
        super(rf);
        this.dist = dist;
        this.maxdepth = maxdepth;
        this.firstUniform = firstUniform;
    }

    @Override
    public double[][] chooseInitialMeans(CFTree<?> tree, List<? extends ClusterFeature> cfs, int k) {
        if (tree.numLeaves() < k) {
            throw new IllegalArgumentException("Cannot choose k=" + k + " means from N=" + tree.numLeaves() + " < k objects.");
        }
        this.maxdepth = this.maxdepth > 0 ? this.maxdepth : (int)Math.ceil(FastMath.log((double)k) / FastMath.log((double)tree.getCapacity())) + 1;
        ArrayList<ClusterFeature> ccs = new ArrayList<ClusterFeature>(k);
        Random rnd = this.rf.getSingleThreadedRandom();
        if (this.firstUniform) {
            ccs.add(cfs.get(rnd.nextInt(cfs.size())).getCF());
        } else {
            List<ClusterFeature> rootcf = Arrays.asList(tree.getRoot().getCF());
            AsClusterFeature next = tree.getRoot();
            for (int depth = this.maxdepth; next instanceof CFNode && depth > 0; --depth) {
                next = this.chooseNextNode((CFNode<?>)next, (List<? extends ClusterFeature>)rootcf, rnd);
            }
            ccs.add(next.getCF());
        }
        while (ccs.size() < k) {
            AsClusterFeature next = tree.getRoot();
            for (int depth = this.maxdepth; next instanceof CFNode && depth > 0; --depth) {
                next = this.chooseNextNode((CFNode<?>)next, (List<? extends ClusterFeature>)ccs, rnd);
            }
            ccs.add(next.getCF());
        }
        double[][] means = new double[k][];
        for (int i = 0; i < k; ++i) {
            means[i] = ((ClusterFeature)ccs.get(i)).toArray();
        }
        return means;
    }

    private AsClusterFeature chooseNextNode(CFNode<?> current, List<? extends ClusterFeature> ccs, Random rnd) {
        AsClusterFeature child;
        double weightsum = 0.0;
        double[] weights = new double[current.capacity()];
        int i = 0;
        while ((child = current.getChild(i)) != null) {
            double minweight = Double.POSITIVE_INFINITY;
            for (int j = 0; j < ccs.size(); ++j) {
                double weight = this.dist.squaredWeight(ccs.get(j).getCF(), child.getCF());
                minweight = weight < minweight ? weight : minweight;
            }
            int n = i++;
            double d = minweight;
            weights[n] = d;
            weightsum += d;
        }
        while (true) {
            double r = rnd.nextDouble() * weightsum;
            for (int j = 0; j < i; ++j) {
                double d;
                r -= weights[j];
                if (!(d <= 0.0)) continue;
                return current.getChild(j);
            }
            weightsum -= r;
        }
    }

    public static class Par
    extends AbstractCFKMeansInitialization.Par {
        public static final OptionID DEPTH_ID = new OptionID("kmpp.depth", "maximum depth for intitialization");
        public static final OptionID KMPP_DISTANCE_ID = CFKPlusPlusLeaves.Par.KMPP_DISTANCE_ID;
        public static final OptionID FIRST_UNIFORM_ID = CFKPlusPlusLeaves.Par.FIRST_UNIFORM_ID;
        CFInitWeight dist = null;
        boolean firstUniform = false;
        int depth = -1;

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            new ObjectParameter(KMPP_DISTANCE_ID, CFInitWeight.class, VarianceWeight.class).grab(config, x -> {
                this.dist = x;
            });
            new Flag(FIRST_UNIFORM_ID).grab(config, x -> {
                this.firstUniform = x;
            });
            new IntParameter(DEPTH_ID, -1).grab(config, x -> {
                this.depth = x;
            });
        }

        public CFKPlusPlusTree make() {
            return new CFKPlusPlusTree(this.dist, this.firstUniform, this.depth, this.rnd);
        }
    }
}

