/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.initialization.betula;

import elki.clustering.kmeans.initialization.betula.CFInitWeight;
import elki.clustering.kmeans.initialization.betula.CFKPlusPlusLeaves;
import elki.index.tree.betula.CFNode;
import elki.index.tree.betula.CFTree;
import elki.index.tree.betula.features.AsClusterFeature;
import elki.index.tree.betula.features.ClusterFeature;
import elki.utilities.Alias;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.List;

@Alias(value={"trunk"})
@Reference(authors="Andreas Lang and Erich Schubert", title="BETULA: Fast Clustering of Large Data with Improved BIRCH CF-Trees", booktitle="Information Systems", url="https://doi.org/10.1016/j.is.2021.101918", bibkey="DBLP:journals/is/LangS22")
public class CFKPlusPlusTrunk
extends CFKPlusPlusLeaves {
    public CFKPlusPlusTrunk(CFInitWeight dist, boolean firstUniform, RandomFactory rf) {
        super(dist, firstUniform, rf);
    }

    @Override
    public double[][] chooseInitialMeans(CFTree<?> tree, List<? extends ClusterFeature> cfs, int k) {
        if (tree.numLeaves() < k) {
            throw new IllegalArgumentException("Cannot choose k=" + k + " means from N=" + tree.numLeaves() + " < k objects.");
        }
        ArrayList<ClusterFeature> current = new ArrayList<ClusterFeature>(k * tree.getCapacity() >> 1);
        ArrayList<CFNode> todo = new ArrayList<CFNode>(1);
        todo.add(tree.getRoot());
        while (todo.size() + current.size() < k && !todo.isEmpty()) {
            ArrayList<CFNode> prev = todo;
            todo = new ArrayList(prev.size() * tree.getCapacity());
            for (int j = 0; j < prev.size(); ++j) {
                AsClusterFeature child;
                CFNode node = (CFNode)prev.get(j);
                for (int i = 0; i < node.capacity() && (child = node.getChild(i)) != null; ++i) {
                    if (child instanceof CFNode) {
                        todo.add((CFNode)child);
                        continue;
                    }
                    current.add(child.getCF());
                }
            }
        }
        for (CFNode node : todo) {
            current.add((ClusterFeature)node.getCF());
        }
        return super.chooseInitialMeans(tree, current, k);
    }

    public static class Par
    extends CFKPlusPlusLeaves.Par {
        @Override
        public void configure(Parameterization config) {
            super.configure(config);
        }

        @Override
        public CFKPlusPlusTrunk make() {
            return new CFKPlusPlusTrunk(this.dist, this.firstUniform, this.rnd);
        }
    }
}

