/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.initialization.betula;

import elki.clustering.kmeans.initialization.betula.AbstractCFKMeansInitialization;
import elki.index.tree.betula.CFTree;
import elki.index.tree.betula.features.ClusterFeature;
import elki.utilities.documentation.Reference;
import elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

@Reference(authors="Andreas Lang and Erich Schubert", title="BETULA: Fast Clustering of Large Data with Improved BIRCH CF-Trees", booktitle="Information Systems", url="https://doi.org/10.1016/j.is.2021.101918", bibkey="DBLP:journals/is/LangS22")
public class CFWeightedRandomlyChosen
extends AbstractCFKMeansInitialization {
    public CFWeightedRandomlyChosen(RandomFactory rf) {
        super(rf);
    }

    @Override
    public double[][] chooseInitialMeans(CFTree<?> tree, List<? extends ClusterFeature> cfs, int k) {
        int leaves = cfs.size();
        if (leaves < k) {
            throw new IllegalArgumentException("Cannot choose k=" + k + " means from N=" + leaves + " < k objects.");
        }
        Random rnd = this.rf.getSingleThreadedRandom();
        double[][] means = new double[k][];
        int weightsum = tree.getRoot().getCF().getWeight();
        ArrayList<? extends ClusterFeature> cpy = new ArrayList<ClusterFeature>(cfs);
        for (int i = 0; i < k; ++i) {
            int weightpos = rnd.nextInt(weightsum);
            int off = 0;
            while ((weightpos -= cpy.get(off).getWeight()) >= 0) {
                ++off;
            }
            means[i] = cpy.get(off).toArray();
            weightsum -= cpy.get(off).getWeight();
            cpy.set(off, cpy.get(cpy.size() - i - 1));
        }
        return means;
    }

    public static class Par
    extends AbstractCFKMeansInitialization.Par {
        public CFWeightedRandomlyChosen make() {
            return new CFWeightedRandomlyChosen(this.rnd);
        }
    }
}

