/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.parallel;

import elki.clustering.ClusteringAlgorithmUtil;
import elki.clustering.kmeans.AbstractKMeans;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.clustering.kmeans.parallel.KMeansProcessor;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.KMeansModel;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.IntegerDataStore;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDs;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.IndefiniteProgress;
import elki.parallel.ParallelExecutor;
import elki.parallel.processor.Processor;
import elki.result.Metadata;

public class ParallelLloydKMeans<V extends NumberVector>
extends AbstractKMeans<V, KMeansModel> {
    private static final Logging LOG = Logging.getLogger(ParallelLloydKMeans.class);

    public ParallelLloydKMeans(NumberVectorDistance<? super V> distance, int k, int maxiter, KMeansInitialization initializer) {
        super(distance, k, maxiter, initializer);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    @Override
    public Clustering<KMeansModel> run(Relation<V> relation) {
        DBIDs ids = relation.getDBIDs();
        double[][] means = this.initialMeans(relation);
        WritableIntegerDataStore assignment = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)3, (int)-1);
        double[] varsum = new double[this.k];
        KMeansProcessor<V> kmm = new KMeansProcessor<V>(relation, this.distance, assignment, varsum);
        IndefiniteProgress prog = LOG.isVerbose() ? new IndefiniteProgress("K-Means iteration", LOG) : null;
        for (int iteration = 0; this.maxiter <= 0 || iteration < this.maxiter; ++iteration) {
            LOG.incrementProcessed((AbstractProgress)prog);
            kmm.nextIteration(means);
            ParallelExecutor.run((DBIDs)ids, (Processor[])new Processor[]{kmm});
            if (!kmm.changed()) break;
            means = kmm.getMeans();
        }
        LOG.setCompleted(prog);
        ArrayModifiableDBIDs[] clusters = ClusteringAlgorithmUtil.partitionsFromIntegerLabels(ids, (IntegerDataStore)assignment, this.k);
        Clustering<KMeansModel> result = new Clustering<KMeansModel>();
        Metadata.of(result).setLongName("k-Means Clustering");
        for (int i = 0; i < clusters.length; ++i) {
            ArrayModifiableDBIDs cids = clusters[i];
            if (cids.size() == 0) continue;
            result.addToplevelCluster(new Cluster<KMeansModel>((DBIDs)cids, new KMeansModel(means[i], varsum[i])));
        }
        return result;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V extends NumberVector>
    extends AbstractKMeans.Par<V> {
        @Override
        public ParallelLloydKMeans<V> make() {
            return new ParallelLloydKMeans(this.distance, this.k, this.maxiter, this.initializer);
        }
    }
}

