/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.quality;

import elki.clustering.kmeans.quality.KMeansQualityMeasure;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.DoubleVector;
import elki.data.NumberVector;
import elki.data.model.KMeansModel;
import elki.data.model.MeanModel;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.distance.NumberVectorDistance;
import elki.math.MathUtil;
import elki.utilities.documentation.Reference;
import java.util.Iterator;
import java.util.List;
import net.jafama.FastMath;

public abstract class AbstractKMeansQualityMeasure<O extends NumberVector>
implements KMeansQualityMeasure<O> {
    public static int numPoints(Clustering<? extends MeanModel> clustering) {
        int n = 0;
        for (Cluster<? extends MeanModel> aCluster : clustering.getAllClusters()) {
            n += aCluster.size();
        }
        return n;
    }

    public static double varianceContributionOfCluster(Cluster<? extends MeanModel> cluster, NumberVectorDistance<?> distance, Relation<? extends NumberVector> relation) {
        if (cluster.size() <= 1) {
            return 0.0;
        }
        MeanModel model = cluster.getModel();
        double v = 0.0;
        if (model instanceof KMeansModel && !Double.isNaN(v = ((KMeansModel)model).getVarianceContribution())) {
            return v;
        }
        DoubleVector mean = DoubleVector.wrap((double[])model.getMean());
        boolean squared = distance.isSquared();
        double variance = 0.0;
        DBIDIter iter = cluster.getIDs().iter();
        while (iter.valid()) {
            double dist = distance.distance((NumberVector)relation.get((DBIDRef)iter), (NumberVector)mean);
            variance += squared ? dist : dist * dist;
            iter.advance();
        }
        return variance;
    }

    @Reference(authors="A. Foglia, B. Hancock", title="Notes on Bayesian Information Criterion Calculation for X-Means Clustering", booktitle="Online", url="https://github.com/bobhancock/goxmeans/blob/master/doc/BIC_notes.pdf", bibkey="web/FogliaH12")
    public static double logLikelihood(Relation<? extends NumberVector> relation, Clustering<? extends MeanModel> clustering, NumberVectorDistance<?> distance) {
        List<Cluster<? extends MeanModel>> clusters = clustering.getAllClusters();
        int m = clusters.size();
        int n = 0;
        int[] n_i = new int[m];
        double d = 0.0;
        Iterator<Cluster<? extends MeanModel>> it = clusters.iterator();
        int i = 0;
        while (it.hasNext()) {
            Cluster<? extends MeanModel> cluster = it.next();
            n_i[i] = cluster.size();
            n += n_i[i];
            d += AbstractKMeansQualityMeasure.varianceContributionOfCluster(cluster, distance, relation);
            ++i;
        }
        if (n <= m) {
            return Double.NEGATIVE_INFINITY;
        }
        int dim = RelationUtil.dimensionality(relation);
        double logv = FastMath.log((double)(d > 0.0 ? d / (double)((n - m) * dim) : Double.MIN_NORMAL));
        double logLikelihood = 0.0;
        for (int i2 = 0; i2 < m; ++i2) {
            logLikelihood += (double)n_i[i2] * FastMath.log((double)n_i[i2]);
        }
        return logLikelihood -= (double)n * FastMath.log((double)n) + (double)(n * dim) * 0.5 * (MathUtil.LOGTWOPI + logv) + (double)((n - m) * dim) * 0.5;
    }

    public static int numberOfFreeParameters(Relation<? extends NumberVector> relation, Clustering<? extends MeanModel> clustering) {
        int m = clustering.getAllClusters().size();
        int dim = RelationUtil.dimensionality(relation);
        return (m + 1) * dim;
    }
}

