/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.quality;

import elki.clustering.kmeans.quality.AbstractKMeansQualityMeasure;
import elki.clustering.kmeans.quality.BayesianInformationCriterionXMeans;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.MeanModel;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.utilities.documentation.Reference;

@Reference(authors="D. Pelleg, A. Moore", title="X-means: Extending K-means with Efficient Estimation on the Number of Clusters", booktitle="Proc. 17th Int. Conf. on Machine Learning (ICML 2000)", url="http://www.pelleg.org/shared/hp/download/xmeans.ps", bibkey="DBLP:conf/icml/PellegM00")
public class AkaikeInformationCriterionXMeans
extends AbstractKMeansQualityMeasure<NumberVector> {
    @Override
    public <V extends NumberVector> double quality(Clustering<? extends MeanModel> clustering, NumberVectorDistance<? super V> distance, Relation<V> relation) {
        return BayesianInformationCriterionXMeans.logLikelihoodXMeans(relation, clustering, distance) - (double)AkaikeInformationCriterionXMeans.numberOfFreeParameters(relation, clustering);
    }

    @Override
    public boolean isBetter(double currentCost, double bestCost) {
        return !(currentCost <= bestCost);
    }
}

