/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.quality;

import elki.clustering.kmeans.quality.AbstractKMeansQualityMeasure;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.MeanModel;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.utilities.documentation.Reference;
import net.jafama.FastMath;

@Reference(authors="G. Schwarz", title="Estimating the dimension of a model", booktitle="The annals of statistics 6.2", url="https://doi.org/10.1214/aos/1176344136", bibkey="doi:10.1214/aos/1176344136")
public class BayesianInformationCriterion
extends AbstractKMeansQualityMeasure<NumberVector> {
    @Override
    public <V extends NumberVector> double quality(Clustering<? extends MeanModel> clustering, NumberVectorDistance<? super V> distance, Relation<V> relation) {
        return BayesianInformationCriterion.logLikelihood(relation, clustering, distance) - 0.5 * (double)BayesianInformationCriterion.numberOfFreeParameters(relation, clustering) * FastMath.log((double)BayesianInformationCriterion.numPoints(clustering));
    }

    @Override
    public boolean isBetter(double currentCost, double bestCost) {
        return !(currentCost <= bestCost);
    }
}

