/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.quality;

import elki.clustering.kmeans.quality.AbstractKMeansQualityMeasure;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.MeanModel;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.distance.NumberVectorDistance;
import elki.math.MathUtil;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import java.util.Iterator;
import java.util.List;
import net.jafama.FastMath;

@Title(value="Bayesian Information Criterion (X-means Version)")
@Reference(authors="D. Pelleg, A. Moore", title="X-means: Extending K-means with Efficient Estimation on the Number of Clusters", booktitle="Proc. 17th Int. Conf. on Machine Learning (ICML 2000)", url="http://www.pelleg.org/shared/hp/download/xmeans.ps", bibkey="DBLP:conf/icml/PellegM00")
public class BayesianInformationCriterionXMeans
extends AbstractKMeansQualityMeasure<NumberVector> {
    @Override
    public <V extends NumberVector> double quality(Clustering<? extends MeanModel> clustering, NumberVectorDistance<? super V> distance, Relation<V> relation) {
        return BayesianInformationCriterionXMeans.logLikelihoodXMeans(relation, clustering, distance) - 0.5 * (double)BayesianInformationCriterionXMeans.numberOfFreeParameters(relation, clustering) * FastMath.log((double)BayesianInformationCriterionXMeans.numPoints(clustering));
    }

    public static double logLikelihoodXMeans(Relation<? extends NumberVector> relation, Clustering<? extends MeanModel> clustering, NumberVectorDistance<?> distance) {
        List<Cluster<? extends MeanModel>> clusters = clustering.getAllClusters();
        int m = clusters.size();
        int n = 0;
        int[] n_i = new int[m];
        double d = 0.0;
        double[] d_i = new double[m];
        Iterator<Cluster<? extends MeanModel>> it = clusters.iterator();
        int i = 0;
        while (it.hasNext()) {
            Cluster<? extends MeanModel> cluster = it.next();
            n_i[i] = cluster.size();
            n += n_i[i];
            d_i[i] = BayesianInformationCriterionXMeans.varianceContributionOfCluster(cluster, distance, relation);
            d += d_i[i];
            ++i;
        }
        if (n <= m) {
            return Double.NEGATIVE_INFINITY;
        }
        double logv = FastMath.log((double)(d / (double)(n - m)));
        int dim = RelationUtil.dimensionality(relation);
        double logLikelihood = 0.0;
        for (int i2 = 0; i2 < m; ++i2) {
            logLikelihood += (double)n_i[i2] * FastMath.log((double)n_i[i2]) - (double)n_i[i2] * 0.5 * MathUtil.LOGTWOPI - (double)(n_i[i2] * dim) * 0.5 * logv - (d_i[i2] - (double)m) * 0.5 - (double)n_i[i2] * FastMath.log((double)n);
        }
        return logLikelihood;
    }

    @Override
    public boolean isBetter(double currentCost, double bestCost) {
        return !(currentCost <= bestCost);
    }
}

