/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.quality;

import elki.clustering.kmeans.quality.AbstractKMeansQualityMeasure;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.MeanModel;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.distance.NumberVectorDistance;
import elki.math.MathUtil;
import elki.utilities.documentation.Reference;
import java.util.Iterator;
import java.util.List;
import net.jafama.FastMath;

@Reference(authors="Q. Zhao, M. Xu, P. Fr\u00e4nti", title="Knee Point Detection on Bayesian Information Criterion", booktitle="20th IEEE International Conference on Tools with Artificial Intelligence", url="https://doi.org/10.1109/ICTAI.2008.154", bibkey="DBLP:conf/ictai/ZhaoXF08")
public class BayesianInformationCriterionZhao
extends AbstractKMeansQualityMeasure<NumberVector> {
    @Override
    public <V extends NumberVector> double quality(Clustering<? extends MeanModel> clustering, NumberVectorDistance<? super V> distance, Relation<V> relation) {
        int dim = RelationUtil.dimensionality(relation);
        return BayesianInformationCriterionZhao.logLikelihoodZhao(relation, clustering, distance) - 0.5 * (double)clustering.getAllClusters().size() * FastMath.log((double)BayesianInformationCriterionZhao.numPoints(clustering)) * (double)(dim + 1);
    }

    public static double logLikelihoodZhao(Relation<? extends NumberVector> relation, Clustering<? extends MeanModel> clustering, NumberVectorDistance<?> distance) {
        List<Cluster<? extends MeanModel>> clusters = clustering.getAllClusters();
        int m = clusters.size();
        int n = 0;
        int[] n_i = new int[m];
        double[] d_i = new double[m];
        Iterator<Cluster<? extends MeanModel>> it = clusters.iterator();
        int i = 0;
        while (it.hasNext()) {
            Cluster<? extends MeanModel> cluster = it.next();
            n_i[i] = cluster.size();
            n += n_i[i];
            d_i[i] = BayesianInformationCriterionZhao.varianceContributionOfCluster(cluster, distance, relation) / (double)n_i[i];
            ++i;
        }
        int dim = RelationUtil.dimensionality(relation);
        double logLikelihood = 0.0;
        for (int i2 = 0; i2 < m; ++i2) {
            logLikelihood += (double)n_i[i2] * FastMath.log((double)((double)n_i[i2] / (double)n)) - (double)(n_i[i2] * dim) * 0.5 * MathUtil.LOGTWOPI - (double)n_i[i2] * 0.5 * FastMath.log((double)d_i[i2]) - (double)(n_i[i2] - m) * 0.5;
        }
        return logLikelihood;
    }

    @Override
    public boolean isBetter(double currentCost, double bestCost) {
        return !(currentCost <= bestCost);
    }
}

