/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.quality;

import elki.clustering.kmeans.quality.KMeansQualityMeasure;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.MeanModel;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;

public class WithinClusterMeanDistance
implements KMeansQualityMeasure<NumberVector> {
    @Override
    public <V extends NumberVector> double quality(Clustering<? extends MeanModel> clustering, NumberVectorDistance<? super V> distance, Relation<V> relation) {
        double clusterDistanceSum = 0.0;
        for (Cluster<? extends MeanModel> cluster : clustering.getAllClusters()) {
            DBIDs ids = cluster.getIDs();
            double clusterPairwiseDistanceSum = 0.0;
            DBIDIter iter1 = ids.iter();
            while (iter1.valid()) {
                NumberVector obj1 = (NumberVector)relation.get((DBIDRef)iter1);
                DBIDIter iter2 = ids.iter();
                while (iter2.valid()) {
                    clusterPairwiseDistanceSum += distance.distance(obj1, (NumberVector)relation.get((DBIDRef)iter2));
                    iter2.advance();
                }
                iter1.advance();
            }
            clusterDistanceSum += clusterPairwiseDistanceSum / (double)(ids.size() * ids.size());
        }
        return clusterDistanceSum / (double)clustering.getAllClusters().size();
    }

    @Override
    public boolean isBetter(double currentCost, double bestCost) {
        return !(currentCost >= bestCost);
    }
}

