/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.spherical;

import elki.clustering.kmeans.AbstractKMeans;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.clustering.kmeans.spherical.EuclideanSphericalSimplifiedElkanKMeans;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.KMeansModel;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.Relation;
import elki.logging.Logging;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;

@Priority(value=-100)
@Reference(authors="Erich Schubert, Andreas Lang, Gloria Feher", title="Accelerating Spherical k-Means", booktitle="Int. Conf. on Similarity Search and Applications, SISAP 2021", url="https://doi.org/10.1007/978-3-030-89657-7_17", bibkey="DBLP:conf/sisap/SchubertLF21")
public class EuclideanSphericalElkanKMeans<V extends NumberVector>
extends EuclideanSphericalSimplifiedElkanKMeans<V> {
    private static final Logging LOG = Logging.getLogger(EuclideanSphericalElkanKMeans.class);

    public EuclideanSphericalElkanKMeans(int k, int maxiter, KMeansInitialization initializer, boolean varstat) {
        super(k, maxiter, initializer, varstat);
    }

    @Override
    public Clustering<KMeansModel> run(Relation<V> relation) {
        Instance instance = new Instance(relation, this.initialMeans(relation));
        instance.run(this.maxiter);
        return instance.buildResult(this.varstat, relation);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V extends NumberVector>
    extends EuclideanSphericalSimplifiedElkanKMeans.Par<V> {
        @Override
        public EuclideanSphericalElkanKMeans<V> make() {
            return new EuclideanSphericalElkanKMeans(this.k, this.maxiter, this.initializer, this.varstat);
        }
    }

    protected static class Instance
    extends EuclideanSphericalSimplifiedElkanKMeans.Instance {
        double[][] cdist;

        public Instance(Relation<? extends NumberVector> relation, double[][] means) {
            super(relation, means);
            this.cdist = new double[this.k][this.k];
            this.cdist = new double[this.k][this.k];
        }

        @Override
        protected int initialAssignToNearestCluster() {
            assert (this.k == this.means.length);
            this.initialSeperation(this.cdist);
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                int j;
                NumberVector fv = (NumberVector)this.relation.get((DBIDRef)it);
                double[] l = (double[])this.lower.get((DBIDRef)it);
                double best = l[0] = this.sqrtdistance(fv, this.means[0]);
                int minIndex = 0;
                for (j = 1; j < this.k; ++j) {
                    double dist;
                    if (!(best > this.cdist[minIndex][j]) || !((dist = (l[j] = this.sqrtdistance(fv, this.means[j]))) < best)) continue;
                    minIndex = j;
                    best = dist;
                }
                for (j = 1; j < this.k; ++j) {
                    if (l[j] != 0.0 || j == minIndex) continue;
                    l[j] = 2.0 * this.cdist[minIndex][j] - best;
                }
                ((ModifiableDBIDs)this.clusters.get(minIndex)).add((DBIDRef)it);
                this.assignment.putInt((DBIDRef)it, minIndex);
                AbstractKMeans.plusEquals(this.sums[minIndex], fv);
                this.upper.putDouble((DBIDRef)it, best);
                it.advance();
            }
            return this.relation.size();
        }

        @Override
        protected int assignToNearestCluster() {
            this.recomputeSeperation(this.sep, this.cdist);
            int changed = 0;
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                int orig = this.assignment.intValue((DBIDRef)it);
                double u = this.upper.doubleValue((DBIDRef)it);
                if (!(u <= this.sep[orig])) {
                    boolean recompute_u = true;
                    NumberVector fv = (NumberVector)this.relation.get((DBIDRef)it);
                    double[] l = (double[])this.lower.get((DBIDRef)it);
                    int cur = orig;
                    for (int j = 0; j < this.k; ++j) {
                        double dist;
                        if (orig == j || u <= l[j] || u <= this.cdist[cur][j]) continue;
                        if (recompute_u) {
                            u = this.sqrtdistance(fv, this.means[cur]);
                            this.upper.putDouble((DBIDRef)it, u);
                            recompute_u = false;
                            if (u <= l[j] || u <= this.cdist[cur][j]) continue;
                        }
                        if (!((dist = (l[j] = this.sqrtdistance(fv, this.means[j]))) < u)) continue;
                        cur = j;
                        u = dist;
                    }
                    if (cur != orig) {
                        ((ModifiableDBIDs)this.clusters.get(cur)).add((DBIDRef)it);
                        ((ModifiableDBIDs)this.clusters.get(orig)).remove((DBIDRef)it);
                        this.assignment.putInt((DBIDRef)it, cur);
                        AbstractKMeans.plusMinusEquals(this.sums[cur], this.sums[orig], fv);
                        ++changed;
                        this.upper.putDouble((DBIDRef)it, u);
                    }
                }
                it.advance();
            }
            return changed;
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

