/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.spherical;

import elki.clustering.kmeans.AbstractKMeans;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.clustering.kmeans.spherical.SphericalKMeans;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.KMeansModel;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.logging.Logging;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.parameterization.Parameterization;

@Priority(value=-100)
@Reference(authors="Erich Schubert, Andreas Lang, Gloria Feher", title="Accelerating Spherical k-Means", booktitle="Int. Conf. on Similarity Search and Applications, SISAP 2021", url="https://doi.org/10.1007/978-3-030-89657-7_17", bibkey="DBLP:conf/sisap/SchubertLF21")
public class EuclideanSphericalHamerlyKMeans<V extends NumberVector>
extends SphericalKMeans<V> {
    private static final Logging LOG = Logging.getLogger(EuclideanSphericalHamerlyKMeans.class);
    protected boolean varstat;

    public EuclideanSphericalHamerlyKMeans(int k, int maxiter, KMeansInitialization initializer, boolean varstat) {
        super(k, maxiter, initializer);
        this.varstat = varstat;
    }

    @Override
    public Clustering<KMeansModel> run(Relation<V> relation) {
        Instance instance = new Instance(relation, this.initialMeans(relation));
        instance.run(this.maxiter);
        return instance.buildResult(this.varstat, relation);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V extends NumberVector>
    extends SphericalKMeans.Par<V> {
        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            super.getParameterVarstat(config);
        }

        @Override
        public EuclideanSphericalHamerlyKMeans<V> make() {
            return new EuclideanSphericalHamerlyKMeans(this.k, this.maxiter, this.initializer, this.varstat);
        }
    }

    protected static class Instance
    extends SphericalKMeans.Instance {
        double[][] sums;
        double[][] newmeans;
        WritableDoubleDataStore upper;
        WritableDoubleDataStore lower;
        double[] sep;

        public Instance(Relation<? extends NumberVector> relation, double[][] means) {
            super(relation, means);
            this.upper = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)3, (double)Double.POSITIVE_INFINITY);
            this.lower = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)3, (double)0.0);
            int dim = RelationUtil.maxDimensionality(relation);
            this.sums = new double[this.k][dim];
            this.newmeans = new double[this.k][dim];
            this.sep = new double[this.k];
        }

        @Override
        public int iterate(int iteration) {
            if (iteration == 1) {
                return this.initialAssignToNearestCluster();
            }
            this.meansFromSums(this.newmeans, this.sums, this.means);
            this.movedDistance(this.means, this.newmeans, this.sep);
            this.updateBounds(this.sep);
            this.copyMeans(this.newmeans, this.means);
            return this.assignToNearestCluster();
        }

        protected int initialAssignToNearestCluster() {
            assert (this.k == this.means.length);
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                NumberVector fv = (NumberVector)this.relation.get((DBIDRef)it);
                double max1 = this.similarity(fv, this.means[0]);
                double max2 = this.k > 1 ? this.similarity(fv, this.means[1]) : max1;
                int maxIndex = 0;
                if (max2 > max1) {
                    double tmp = max1;
                    max1 = max2;
                    max2 = tmp;
                    maxIndex = 1;
                }
                for (int j = 2; j < this.k; ++j) {
                    double sim = this.similarity(fv, this.means[j]);
                    if (sim > max1) {
                        maxIndex = j;
                        max2 = max1;
                        max1 = sim;
                        continue;
                    }
                    if (!(sim > max2)) continue;
                    max2 = sim;
                }
                ((ModifiableDBIDs)this.clusters.get(maxIndex)).add((DBIDRef)it);
                this.assignment.putInt((DBIDRef)it, maxIndex);
                AbstractKMeans.plusEquals(this.sums[maxIndex], fv);
                this.upper.putDouble((DBIDRef)it, Math.sqrt(2.0 - 2.0 * max1));
                this.lower.putDouble((DBIDRef)it, Math.sqrt(2.0 - 2.0 * max2));
                it.advance();
            }
            return this.relation.size();
        }

        @Override
        protected int assignToNearestCluster() {
            int changed = 0;
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                int orig = this.assignment.intValue((DBIDRef)it);
                double l = this.lower.doubleValue((DBIDRef)it);
                double u = this.upper.doubleValue((DBIDRef)it);
                if (!(u <= l)) {
                    NumberVector fv = (NumberVector)this.relation.get((DBIDRef)it);
                    double curSim = this.similarity(fv, this.means[orig]);
                    u = Math.sqrt(2.0 - 2.0 * curSim);
                    this.upper.putDouble((DBIDRef)it, u);
                    if (!(u <= l)) {
                        double max1 = curSim;
                        double max2 = Double.NEGATIVE_INFINITY;
                        int cur = orig;
                        for (int i = 0; i < this.k; ++i) {
                            if (i == orig) continue;
                            double sim = this.similarity(fv, this.means[i]);
                            if (sim > max1) {
                                cur = i;
                                max2 = max1;
                                max1 = sim;
                                continue;
                            }
                            if (!(sim > max2)) continue;
                            max2 = sim;
                        }
                        if (cur != orig) {
                            ((ModifiableDBIDs)this.clusters.get(cur)).add((DBIDRef)it);
                            ((ModifiableDBIDs)this.clusters.get(orig)).remove((DBIDRef)it);
                            this.assignment.putInt((DBIDRef)it, cur);
                            AbstractKMeans.plusMinusEquals(this.sums[cur], this.sums[orig], fv);
                            ++changed;
                            this.upper.putDouble((DBIDRef)it, max1 == curSim ? u : Math.sqrt(2.0 - 2.0 * max1));
                        }
                        this.lower.putDouble((DBIDRef)it, max2 == curSim ? u : Math.sqrt(2.0 - 2.0 * max2));
                    }
                }
                it.advance();
            }
            return changed;
        }

        protected void updateBounds(double[] move) {
            int most = 0;
            double delta = move[0];
            double delta2 = 0.0;
            for (int i = 1; i < move.length; ++i) {
                double m = move[i];
                if (m > delta) {
                    delta2 = delta;
                    delta = m;
                    most = i;
                    continue;
                }
                if (!(m > delta2)) continue;
                delta2 = m;
            }
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                int a = this.assignment.intValue((DBIDRef)it);
                this.upper.increment((DBIDRef)it, move[a]);
                this.lower.increment((DBIDRef)it, a == most ? -delta2 : -delta);
                it.advance();
            }
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

