/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.spherical;

import elki.clustering.kmeans.AbstractKMeans;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.clustering.kmeans.spherical.SphericalKMeans;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.KMeansModel;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.logging.Logging;
import elki.math.linearalgebra.VMath;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.parameterization.Parameterization;

@Priority(value=-100)
@Reference(authors="Erich Schubert, Andreas Lang, Gloria Feher", title="Accelerating Spherical k-Means", booktitle="Int. Conf. on Similarity Search and Applications, SISAP 2021", url="https://doi.org/10.1007/978-3-030-89657-7_17", bibkey="DBLP:conf/sisap/SchubertLF21")
public class EuclideanSphericalSimplifiedElkanKMeans<V extends NumberVector>
extends SphericalKMeans<V> {
    private static final Logging LOG = Logging.getLogger(EuclideanSphericalSimplifiedElkanKMeans.class);
    protected boolean varstat;

    public EuclideanSphericalSimplifiedElkanKMeans(int k, int maxiter, KMeansInitialization initializer, boolean varstat) {
        super(k, maxiter, initializer);
        this.varstat = varstat;
    }

    @Override
    public Clustering<KMeansModel> run(Relation<V> relation) {
        Instance instance = new Instance(relation, this.initialMeans(relation));
        instance.run(this.maxiter);
        return instance.buildResult(this.varstat, relation);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V extends NumberVector>
    extends SphericalKMeans.Par<V> {
        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            super.getParameterVarstat(config);
        }

        @Override
        public EuclideanSphericalSimplifiedElkanKMeans<V> make() {
            return new EuclideanSphericalSimplifiedElkanKMeans(this.k, this.maxiter, this.initializer, this.varstat);
        }
    }

    protected static class Instance
    extends SphericalKMeans.Instance {
        double[][] sums;
        double[][] newmeans;
        WritableDoubleDataStore upper;
        WritableDataStore<double[]> lower;
        double[] sep;

        public Instance(Relation<? extends NumberVector> relation, double[][] means) {
            super(relation, means);
            this.upper = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)3, (double)Double.POSITIVE_INFINITY);
            this.lower = DataStoreUtil.makeStorage((DBIDs)relation.getDBIDs(), (int)3, double[].class);
            DBIDIter it = relation.iterDBIDs();
            while (it.valid()) {
                this.lower.put((DBIDRef)it, (Object)new double[this.k]);
                it.advance();
            }
            int dim = RelationUtil.maxDimensionality(relation);
            this.sums = new double[this.k][dim];
            this.newmeans = new double[this.k][dim];
            this.sep = new double[this.k];
        }

        @Override
        public int iterate(int iteration) {
            if (iteration == 1) {
                return this.initialAssignToNearestCluster();
            }
            this.meansFromSums(this.newmeans, this.sums, this.means);
            this.movedDistance(this.means, this.newmeans, this.sep);
            this.updateBounds(this.sep);
            this.copyMeans(this.newmeans, this.means);
            return this.assignToNearestCluster();
        }

        protected int initialAssignToNearestCluster() {
            assert (this.k == this.means.length);
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                NumberVector fv = (NumberVector)this.relation.get((DBIDRef)it);
                double[] l = (double[])this.lower.get((DBIDRef)it);
                double best = l[0] = this.sqrtdistance(fv, this.means[0]);
                int minIndex = 0;
                for (int j = 1; j < this.k; ++j) {
                    l[j] = this.sqrtdistance(fv, this.means[j]);
                    double dist = l[j];
                    if (!(dist < best)) continue;
                    minIndex = j;
                    best = dist;
                }
                ((ModifiableDBIDs)this.clusters.get(minIndex)).add((DBIDRef)it);
                this.assignment.putInt((DBIDRef)it, minIndex);
                AbstractKMeans.plusEquals(this.sums[minIndex], fv);
                this.upper.putDouble((DBIDRef)it, best);
                it.advance();
            }
            return this.relation.size();
        }

        @Override
        protected int assignToNearestCluster() {
            int changed = 0;
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                int orig = this.assignment.intValue((DBIDRef)it);
                double u = this.upper.doubleValue((DBIDRef)it);
                boolean recompute_u = true;
                NumberVector fv = (NumberVector)this.relation.get((DBIDRef)it);
                double[] l = (double[])this.lower.get((DBIDRef)it);
                int cur = orig;
                for (int j = 0; j < this.k; ++j) {
                    double dist;
                    if (orig == j || u <= l[j]) continue;
                    if (recompute_u) {
                        u = this.sqrtdistance(fv, this.means[cur]);
                        this.upper.putDouble((DBIDRef)it, u);
                        recompute_u = false;
                        if (u <= l[j]) continue;
                    }
                    if (!((dist = (l[j] = this.sqrtdistance(fv, this.means[j]))) < u)) continue;
                    cur = j;
                    u = dist;
                }
                if (cur != orig) {
                    ((ModifiableDBIDs)this.clusters.get(cur)).add((DBIDRef)it);
                    ((ModifiableDBIDs)this.clusters.get(orig)).remove((DBIDRef)it);
                    this.assignment.putInt((DBIDRef)it, cur);
                    AbstractKMeans.plusMinusEquals(this.sums[cur], this.sums[orig], fv);
                    ++changed;
                    this.upper.putDouble((DBIDRef)it, u);
                }
                it.advance();
            }
            return changed;
        }

        protected void updateBounds(double[] move) {
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                this.upper.increment((DBIDRef)it, move[this.assignment.intValue((DBIDRef)it)]);
                VMath.minusEquals((double[])((double[])this.lower.get((DBIDRef)it)), (double[])move);
                it.advance();
            }
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

