/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.spherical;

import elki.clustering.kmeans.AbstractKMeans;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.clustering.kmeans.spherical.SphericalSimplifiedElkanKMeans;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.KMeansModel;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.Relation;
import elki.logging.Logging;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import java.util.Arrays;

@References(value={@Reference(authors="Erich Schubert, Andreas Lang, Gloria Feher", title="Accelerating Spherical k-Means", booktitle="Int. Conf. on Similarity Search and Applications, SISAP 2021", url="https://doi.org/10.1007/978-3-030-89657-7_17", bibkey="DBLP:conf/sisap/SchubertLF21"), @Reference(authors="Erich Schubert", title="A Triangle Inequality for Cosine Similarity", booktitle="Int. Conf. on Similarity Search and Applications, SISAP 2021", url="https://doi.org/10.1007/978-3-030-89657-7_3", bibkey="DBLP:conf/sisap/Schubert21")})
public class SphericalElkanKMeans<V extends NumberVector>
extends SphericalSimplifiedElkanKMeans<V> {
    private static final Logging LOG = Logging.getLogger(SphericalElkanKMeans.class);

    public SphericalElkanKMeans(int k, int maxiter, KMeansInitialization initializer, boolean varstat) {
        super(k, maxiter, initializer, varstat);
    }

    @Override
    public Clustering<KMeansModel> run(Relation<V> relation) {
        Instance instance = new Instance(relation, this.initialMeans(relation));
        instance.run(this.maxiter);
        return instance.buildResult(this.varstat, relation);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V extends NumberVector>
    extends SphericalSimplifiedElkanKMeans.Par<V> {
        @Override
        public SphericalElkanKMeans<V> make() {
            return new SphericalElkanKMeans(this.k, this.maxiter, this.initializer, this.varstat);
        }
    }

    protected static class Instance
    extends SphericalSimplifiedElkanKMeans.Instance {
        double[][] ccsim;

        public Instance(Relation<? extends NumberVector> relation, double[][] means) {
            super(relation, means);
            this.ccsim = new double[this.k][this.k];
            this.ccsim = new double[this.k][this.k];
        }

        @Override
        protected int initialAssignToNearestCluster() {
            assert (this.k == this.means.length);
            this.initialSeparation(this.ccsim);
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                int j;
                NumberVector fv = (NumberVector)this.relation.get((DBIDRef)it);
                double[] us = (double[])this.usim.get((DBIDRef)it);
                double best = us[0] = this.similarity(fv, this.means[0]);
                int maxIndex = 0;
                for (j = 1; j < this.k; ++j) {
                    if (best < this.ccsim[maxIndex][j]) {
                        us[j] = this.similarity(fv, this.means[j]);
                        double sim = us[j];
                        if (!(sim > best)) continue;
                        maxIndex = j;
                        best = sim;
                        continue;
                    }
                    us[j] = 2.0;
                }
                for (j = 1; j < this.k; ++j) {
                    if (us[j] != 2.0) continue;
                    double cc = this.ccsim[maxIndex][j];
                    double simcc = cc * cc * 2.0 - 1.0;
                    us[j] = best * simcc + Math.sqrt((1.0 - best * best) * (1.0 - simcc * simcc));
                }
                ((ModifiableDBIDs)this.clusters.get(maxIndex)).add((DBIDRef)it);
                this.assignment.putInt((DBIDRef)it, maxIndex);
                AbstractKMeans.plusEquals(this.sums[maxIndex], fv);
                this.lsim.putDouble((DBIDRef)it, best);
                it.advance();
            }
            return this.relation.size();
        }

        @Override
        protected void recomputeSeperation(double[] csim, double[][] ccsim) {
            int k = this.means.length;
            assert (csim.length == k);
            Arrays.fill(csim, 0.0);
            for (int i = 1; i < k; ++i) {
                double[] mi = this.means[i];
                for (int j = 0; j < i; ++j) {
                    double sqrtsim;
                    double s = this.similarity(mi, this.means[j]);
                    double d = sqrtsim = s > -1.0 ? Math.sqrt((s + 1.0) * 0.5) : 0.0;
                    ccsim[j][i] = d;
                    ccsim[i][j] = d;
                    csim[i] = sqrtsim > csim[i] ? sqrtsim : csim[i];
                    csim[j] = sqrtsim > csim[j] ? sqrtsim : csim[j];
                }
            }
        }

        @Override
        protected int assignToNearestCluster() {
            this.recomputeSeperation(this.csim, this.ccsim);
            int changed = 0;
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                int orig = this.assignment.intValue((DBIDRef)it);
                double ls = this.lsim.doubleValue((DBIDRef)it);
                if (!(ls >= this.csim[orig])) {
                    boolean recompute_ls = true;
                    NumberVector fv = (NumberVector)this.relation.get((DBIDRef)it);
                    double[] us = (double[])this.usim.get((DBIDRef)it);
                    int cur = orig;
                    for (int j = 0; j < this.k; ++j) {
                        double sim;
                        if (orig == j || ls >= us[j] || ls >= this.ccsim[cur][j]) continue;
                        if (recompute_ls) {
                            ls = this.similarity(fv, this.means[cur]);
                            this.lsim.putDouble((DBIDRef)it, ls);
                            recompute_ls = false;
                            if (ls >= us[j] || ls >= this.ccsim[cur][j]) continue;
                        }
                        if (!((sim = (us[j] = this.similarity(fv, this.means[j]))) > ls)) continue;
                        cur = j;
                        ls = sim;
                    }
                    if (cur != orig) {
                        ((ModifiableDBIDs)this.clusters.get(cur)).add((DBIDRef)it);
                        ((ModifiableDBIDs)this.clusters.get(orig)).remove((DBIDRef)it);
                        this.assignment.putInt((DBIDRef)it, cur);
                        AbstractKMeans.plusMinusEquals(this.sums[cur], this.sums[orig], fv);
                        ++changed;
                        this.lsim.putDouble((DBIDRef)it, ls);
                    }
                }
                it.advance();
            }
            return changed;
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

