/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.spherical;

import elki.clustering.kmeans.AbstractKMeans;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.clustering.kmeans.spherical.SphericalKMeans;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.KMeansModel;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.logging.Logging;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.optionhandling.parameterization.Parameterization;
import java.util.Arrays;

@References(value={@Reference(authors="Erich Schubert, Andreas Lang, Gloria Feher", title="Accelerating Spherical k-Means", booktitle="Int. Conf. on Similarity Search and Applications, SISAP 2021", url="https://doi.org/10.1007/978-3-030-89657-7_17", bibkey="DBLP:conf/sisap/SchubertLF21"), @Reference(authors="Erich Schubert", title="A Triangle Inequality for Cosine Similarity", booktitle="Int. Conf. on Similarity Search and Applications, SISAP 2021", url="https://doi.org/10.1007/978-3-030-89657-7_3", bibkey="DBLP:conf/sisap/Schubert21")})
public class SphericalSimplifiedElkanKMeans<V extends NumberVector>
extends SphericalKMeans<V> {
    private static final Logging LOG = Logging.getLogger(SphericalSimplifiedElkanKMeans.class);
    protected boolean varstat;

    public SphericalSimplifiedElkanKMeans(int k, int maxiter, KMeansInitialization initializer, boolean varstat) {
        super(k, maxiter, initializer);
        this.varstat = varstat;
    }

    @Override
    public Clustering<KMeansModel> run(Relation<V> relation) {
        Instance instance = new Instance(relation, this.initialMeans(relation));
        instance.run(this.maxiter);
        return instance.buildResult(this.varstat, relation);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V extends NumberVector>
    extends SphericalKMeans.Par<V> {
        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            super.getParameterVarstat(config);
        }

        @Override
        public SphericalSimplifiedElkanKMeans<V> make() {
            return new SphericalSimplifiedElkanKMeans(this.k, this.maxiter, this.initializer, this.varstat);
        }
    }

    protected static class Instance
    extends SphericalKMeans.Instance {
        double[][] sums;
        double[][] newmeans;
        WritableDoubleDataStore lsim;
        WritableDataStore<double[]> usim;
        double[] csim;

        public Instance(Relation<? extends NumberVector> relation, double[][] means) {
            super(relation, means);
            this.lsim = DataStoreUtil.makeDoubleStorage((DBIDs)relation.getDBIDs(), (int)3, (double)0.0);
            this.usim = DataStoreUtil.makeStorage((DBIDs)relation.getDBIDs(), (int)3, double[].class);
            DBIDIter it = relation.iterDBIDs();
            while (it.valid()) {
                double[] a = new double[this.k];
                Arrays.fill(a, 2.0);
                this.usim.put((DBIDRef)it, (Object)a);
                it.advance();
            }
            int dim = RelationUtil.maxDimensionality(relation);
            this.sums = new double[this.k][dim];
            this.newmeans = new double[this.k][dim];
            this.csim = new double[this.k];
        }

        @Override
        public int iterate(int iteration) {
            if (iteration == 1) {
                return this.initialAssignToNearestCluster();
            }
            this.meansFromSums(this.newmeans, this.sums, this.means);
            this.movedSimilarity(this.means, this.newmeans, this.csim);
            this.updateBounds(this.csim);
            this.copyMeans(this.newmeans, this.means);
            return this.assignToNearestCluster();
        }

        protected int initialAssignToNearestCluster() {
            assert (this.k == this.means.length);
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                NumberVector fv = (NumberVector)this.relation.get((DBIDRef)it);
                double[] us = (double[])this.usim.get((DBIDRef)it);
                double best = us[0] = this.similarity(fv, this.means[0]);
                int maxIndex = 0;
                for (int j = 1; j < this.k; ++j) {
                    us[j] = this.similarity(fv, this.means[j]);
                    double sim = us[j];
                    if (!(sim > best)) continue;
                    maxIndex = j;
                    best = sim;
                }
                ((ModifiableDBIDs)this.clusters.get(maxIndex)).add((DBIDRef)it);
                this.assignment.putInt((DBIDRef)it, maxIndex);
                AbstractKMeans.plusEquals(this.sums[maxIndex], fv);
                this.lsim.putDouble((DBIDRef)it, best);
                it.advance();
            }
            return this.relation.size();
        }

        @Override
        protected int assignToNearestCluster() {
            int changed = 0;
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                int orig = this.assignment.intValue((DBIDRef)it);
                double ls = this.lsim.doubleValue((DBIDRef)it);
                boolean recompute_ls = true;
                NumberVector fv = (NumberVector)this.relation.get((DBIDRef)it);
                double[] us = (double[])this.usim.get((DBIDRef)it);
                int cur = orig;
                for (int j = 0; j < this.k; ++j) {
                    double sim;
                    if (orig == j || ls >= us[j]) continue;
                    if (recompute_ls) {
                        ls = this.similarity(fv, this.means[cur]);
                        this.lsim.putDouble((DBIDRef)it, ls);
                        recompute_ls = false;
                        if (ls >= us[j]) continue;
                    }
                    if (!((sim = (us[j] = this.similarity(fv, this.means[j]))) > ls)) continue;
                    cur = j;
                    ls = sim;
                }
                if (cur != orig) {
                    ((ModifiableDBIDs)this.clusters.get(cur)).add((DBIDRef)it);
                    ((ModifiableDBIDs)this.clusters.get(orig)).remove((DBIDRef)it);
                    this.assignment.putInt((DBIDRef)it, cur);
                    AbstractKMeans.plusMinusEquals(this.sums[cur], this.sums[orig], fv);
                    ++changed;
                    this.lsim.putDouble((DBIDRef)it, ls);
                }
                it.advance();
            }
            return changed;
        }

        protected void updateBounds(double[] msim) {
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                int ai = this.assignment.intValue((DBIDRef)it);
                double v1 = Math.min(1.0, this.lsim.doubleValue((DBIDRef)it));
                double v2 = msim[ai];
                this.lsim.putDouble((DBIDRef)it, v1 * v2 - Math.sqrt((1.0 - v1 * v1) * (1.0 - v2 * v2)));
                double[] us = (double[])this.usim.get((DBIDRef)it);
                for (int i = 0; i < us.length; ++i) {
                    double w1 = Math.min(1.0, us[i]);
                    double w2 = msim[i];
                    us[i] = w1 * w2 + Math.sqrt((1.0 - w1 * w1) * (1.0 - w2 * w2));
                }
                it.advance();
            }
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

