/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans.spherical;

import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.clustering.kmeans.spherical.SphericalKMeans;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.KMeansModel;
import elki.database.relation.Relation;
import elki.logging.Logging;
import elki.utilities.optionhandling.parameterization.Parameterization;

public class SphericalSingleAssignmentKMeans<V extends NumberVector>
extends SphericalKMeans<V> {
    private static final Logging LOG = Logging.getLogger(SphericalSingleAssignmentKMeans.class);

    public SphericalSingleAssignmentKMeans(int k, KMeansInitialization initializer) {
        super(k, 1, initializer);
    }

    @Override
    public Clustering<KMeansModel> run(Relation<V> relation) {
        Instance instance = new Instance(relation, this.initialMeans(relation));
        instance.run(1);
        return instance.buildResult();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V extends NumberVector>
    extends SphericalKMeans.Par<V> {
        @Override
        public void configure(Parameterization config) {
            this.getParameterK(config);
            this.getParameterInitialization(config);
        }

        @Override
        public SphericalSingleAssignmentKMeans<V> make() {
            return new SphericalSingleAssignmentKMeans(this.k, this.initializer);
        }
    }

    public static class Instance
    extends SphericalKMeans.Instance {
        public Instance(Relation<? extends NumberVector> relation, double[][] means) {
            super(relation, means);
        }

        @Override
        public int iterate(int iteration) {
            assert (iteration == 1);
            return -this.assignToNearestCluster();
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

