/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmedoids;

import elki.Algorithm;
import elki.clustering.kmeans.KMeans;
import elki.clustering.kmeans.initialization.RandomlyChosen;
import elki.clustering.kmedoids.KMedoidsClustering;
import elki.clustering.kmedoids.initialization.AlternateRefinement;
import elki.clustering.kmedoids.initialization.KMedoidsInitialization;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.MedoidModel;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.IntegerDataStore;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.IndefiniteProgress;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.logging.statistics.StringStatistic;
import elki.result.Metadata;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;

@Priority(value=-100)
@References(value={@Reference(authors="F. E. Maranzana", title="On the location of supply points to minimize transport costs", booktitle="Journal of the Operational Research Society 15.3", url="https://doi.org/10.1057/jors.1964.47", bibkey="doi:10.1057/jors.1964.47"), @Reference(authors="A. P. Reynolds, G. Richards, B. de la Iglesia, V. J. Rayward-Smith", title="Clustering Rules: A Comparison of Partitioning and Hierarchical Clustering Algorithms", booktitle="J. Math. Model. Algorithms 5(4)", url="https://doi.org/10.1007/s10852-005-9022-1", bibkey="DBLP:journals/jmma/ReynoldsRIR06"), @Reference(authors="H.-S. Park, C.-H. Jun", title="A simple and fast algorithm for K-medoids clustering", booktitle="Expert Systems with Applications 36(2)", url="https://doi.org/10.1016/j.eswa.2008.01.039", bibkey="DBLP:journals/eswa/ParkJ09")})
public class AlternatingKMedoids<O>
implements KMedoidsClustering<O> {
    private static final Logging LOG = Logging.getLogger(AlternatingKMedoids.class);
    private static final String KEY = AlternatingKMedoids.class.getName();
    protected Distance<? super O> distance;
    protected int k;
    protected int maxiter;
    protected KMedoidsInitialization<O> initializer;

    public AlternatingKMedoids(Distance<? super O> distance, int k, int maxiter, KMedoidsInitialization<O> initializer) {
        this.distance = distance;
        this.k = k;
        this.maxiter = maxiter;
        this.initializer = initializer;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    @Override
    public Clustering<MedoidModel> run(Relation<O> relation) {
        return this.run(relation, this.k, new QueryBuilder(relation, this.distance).precomputed().distanceQuery());
    }

    @Override
    public Clustering<MedoidModel> run(Relation<O> relation, int k, DistanceQuery<? super O> distQ) {
        if (LOG.isStatistics()) {
            LOG.statistics((Statistic)new StringStatistic(KEY + ".initialization", this.initializer.toString()));
        }
        DBIDs ids = relation.getDBIDs();
        ArrayModifiableDBIDs medoids = DBIDUtil.newArray((DBIDs)this.initializer.chooseInitialMedoids(k, ids, distQ));
        DBIDArrayMIter miter = medoids.iter();
        double[] cost = new double[k];
        WritableIntegerDataStore assignment = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)3, (int)0);
        double tc = AlternateRefinement.assignToNearestCluster((DBIDArrayIter)miter, ids, distQ, assignment, cost);
        if (LOG.isStatistics()) {
            LOG.statistics((Statistic)new DoubleStatistic(KEY + ".iteration-" + 0 + ".cost", tc));
        }
        IndefiniteProgress prog = LOG.isVerbose() ? new IndefiniteProgress("K-Medoids EM iteration", LOG) : null;
        int iteration = 0;
        while (iteration < this.maxiter || this.maxiter <= 0) {
            ++iteration;
            boolean changed = false;
            miter.seek(0);
            while (miter.valid()) {
                changed |= AlternateRefinement.findMedoid(ids, distQ, (IntegerDataStore)assignment, miter.getOffset(), miter, cost);
                miter.advance();
            }
            if (!changed) break;
            double nc = AlternateRefinement.assignToNearestCluster((DBIDArrayIter)miter, ids, distQ, assignment, cost);
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new DoubleStatistic(KEY + ".iteration-" + iteration + ".cost", nc));
            }
            if (nc > tc) {
                LOG.warning((CharSequence)(this.getClass().getName() + " failed to converge - numerical instability?"));
                break;
            }
            tc = nc;
            LOG.incrementProcessed((AbstractProgress)prog);
        }
        LOG.setCompleted(prog);
        if (LOG.isStatistics()) {
            LOG.statistics((Statistic)new LongStatistic(KEY + ".iterations", (long)iteration));
            LOG.statistics((Statistic)new DoubleStatistic(KEY + ".final-cost", tc));
        }
        ArrayList<ArrayModifiableDBIDs> clusters = new ArrayList<ArrayModifiableDBIDs>();
        for (int i = 0; i < k; ++i) {
            clusters.add(DBIDUtil.newArray((int)(relation.size() / k / 2)));
        }
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            ((ModifiableDBIDs)clusters.get(assignment.intValue((DBIDRef)iter))).add((DBIDRef)iter);
            iter.advance();
        }
        Clustering<MedoidModel> result = new Clustering<MedoidModel>();
        Metadata.of(result).setLongName("k-Medoids Clustering");
        DBIDArrayMIter it = medoids.iter();
        while (it.valid()) {
            result.addToplevelCluster(new Cluster<MedoidModel>((DBIDs)clusters.get(it.getOffset()), new MedoidModel(DBIDUtil.deref((DBIDRef)it))));
            it.advance();
        }
        return result;
    }

    public static class Par<V>
    implements Parameterizer {
        protected int k;
        protected int maxiter;
        protected KMedoidsInitialization<V> initializer;
        protected Distance<? super V> distance;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(KMeans.K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
            new ObjectParameter(KMeans.INIT_ID, KMedoidsInitialization.class, RandomlyChosen.class).grab(config, x -> {
                this.initializer = x;
            });
            ((IntParameter)new IntParameter(KMeans.MAXITER_ID, 0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_INT)).grab(config, x -> {
                this.maxiter = x;
            });
        }

        public AlternatingKMedoids<V> make() {
            return new AlternatingKMedoids<V>(this.distance, this.k, this.maxiter, this.initializer);
        }
    }
}

