/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmedoids;

import elki.Algorithm;
import elki.clustering.ClusteringAlgorithmUtil;
import elki.clustering.kmeans.KMeans;
import elki.clustering.kmedoids.KMedoidsClustering;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.MedoidModel;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.IntegerDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Statistic;
import elki.result.Metadata;
import elki.utilities.documentation.Reference;
import elki.utilities.exceptions.AbortException;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import java.util.Random;

@Reference(authors="R. T. Ng, J. Han", title="CLARANS: a method for clustering objects for spatial data mining", booktitle="IEEE Transactions on Knowledge and Data Engineering 14(5)", url="https://doi.org/10.1109/TKDE.2002.1033770", bibkey="DBLP:journals/tkde/NgH02")
public class CLARANS<O>
implements KMedoidsClustering<O> {
    private static final Logging LOG = Logging.getLogger(CLARANS.class);
    protected Distance<? super O> distance;
    protected int k;
    protected int numlocal;
    protected double maxneighbor;
    protected RandomFactory random;

    public CLARANS(Distance<? super O> distance, int k, int numlocal, double maxneighbor, RandomFactory random) {
        this.distance = distance;
        this.k = k;
        this.numlocal = numlocal;
        this.maxneighbor = maxneighbor;
        this.random = random;
    }

    @Override
    public Clustering<MedoidModel> run(Relation<O> relation) {
        return this.run(relation, this.k, new QueryBuilder(relation, this.distance).distanceQuery());
    }

    @Override
    public Clustering<MedoidModel> run(Relation<O> relation, int k, DistanceQuery<? super O> distQ) {
        if (relation.size() <= 0) {
            Clustering<MedoidModel> empty = new Clustering<MedoidModel>();
            Metadata.of(empty).setLongName("CLARANS Clustering");
            return empty;
        }
        if (k * 2 >= relation.size()) {
            LOG.warning((CharSequence)"A very large k was chosen. This implementation is not optimized for this case.");
        }
        DBIDs ids = relation.getDBIDs();
        boolean metric = this.distance.isMetric();
        int retries = (int)Math.ceil(this.maxneighbor < 1.0 ? this.maxneighbor * (double)k * (double)(ids.size() - k) : this.maxneighbor);
        Random rnd = this.random.getSingleThreadedRandom();
        DBIDArrayIter cand = DBIDUtil.ensureArray((DBIDs)ids).iter();
        Assignment best = new Assignment(distQ, ids, k);
        Assignment curr = new Assignment(distQ, ids, k);
        Assignment scratch = new Assignment(distQ, ids, k);
        double bestscore = Double.POSITIVE_INFINITY;
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("CLARANS sampling restarts", this.numlocal, LOG) : null;
        for (int i = 0; i < this.numlocal; ++i) {
            curr.medoids.clear().addDBIDs((DBIDs)DBIDUtil.randomSample((DBIDs)ids, (int)k, (Random)rnd));
            double total = curr.assignToNearestCluster();
            int j = 1;
            block1: while (j < retries) {
                int otherm;
                double cost;
                int r = 0;
                while (true) {
                    cand.seek(rnd.nextInt(ids.size()));
                    if (curr.nearest.doubleValue((DBIDRef)cand) > 0.0) break;
                    if (metric && curr.second.doubleValue((DBIDRef)cand) == 0.0) {
                        ++j;
                        continue block1;
                    }
                    if (!metric && !curr.medoids.contains((DBIDRef)cand)) break;
                    if (r >= 1000) {
                        throw new AbortException("Failed to choose a non-medoid in 1000 attempts. Choose k << N.");
                    }
                    ++r;
                }
                if (!((cost = curr.computeCostDifferential((DBIDRef)cand, otherm = rnd.nextInt(k), scratch)) < -1.0E-12 * total)) {
                    ++j;
                    continue;
                }
                total += cost;
                Assignment tmp = curr;
                curr = scratch;
                scratch = tmp;
                j = 1;
            }
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new DoubleStatistic(this.getClass().getName() + ".sample-" + i + ".cost", total));
            }
            if (total < bestscore) {
                Assignment tmp = curr;
                curr = best;
                best = tmp;
                bestscore = total;
            }
            LOG.incrementProcessed((AbstractProgress)prog);
        }
        LOG.ensureCompleted(prog);
        if (LOG.isStatistics()) {
            LOG.statistics((Statistic)new DoubleStatistic(this.getClass().getName() + ".final-cost", bestscore));
        }
        ArrayModifiableDBIDs[] clusters = ClusteringAlgorithmUtil.partitionsFromIntegerLabels(ids, (IntegerDataStore)best.assignment, k);
        Clustering<MedoidModel> result = new Clustering<MedoidModel>();
        DBIDArrayMIter it = best.medoids.iter();
        while (it.valid()) {
            result.addToplevelCluster(new Cluster<MedoidModel>((DBIDs)clusters[it.getOffset()], new MedoidModel(DBIDUtil.deref((DBIDRef)it))));
            it.advance();
        }
        Metadata.of(result).setLongName("CLARANS Clustering");
        return result;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public static class Par<V>
    implements Parameterizer {
        public static final OptionID RESTARTS_ID = new OptionID("clara.numlocal", "Number of samples (restarts) to run.");
        public static final OptionID NEIGHBORS_ID = new OptionID("clara.numneighbor", "Number of tries to find a neighbor.");
        public static final OptionID RANDOM_ID = new OptionID("clarans.random", "Random generator seed.");
        double maxneighbor;
        int numlocal;
        int k;
        RandomFactory random;
        protected Distance<? super V> distance;

        protected double defaultRate() {
            return 0.0125;
        }

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(KMeans.K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
            ((IntParameter)new IntParameter(RESTARTS_ID, 2).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.numlocal = x;
            });
            ((DoubleParameter)new DoubleParameter(NEIGHBORS_ID, this.defaultRate()).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).grab(config, x -> {
                this.maxneighbor = x;
            });
            new RandomParameter(RANDOM_ID).grab(config, x -> {
                this.random = x;
            });
        }

        public CLARANS<V> make() {
            return new CLARANS<V>(this.distance, this.k, this.numlocal, this.maxneighbor, this.random);
        }
    }

    protected static class Assignment {
        DBIDs ids;
        DistanceQuery<?> distQ;
        WritableDoubleDataStore nearest;
        WritableDoubleDataStore second;
        WritableIntegerDataStore assignment;
        WritableIntegerDataStore secondid;
        ArrayModifiableDBIDs medoids;
        DBIDArrayMIter miter;

        public Assignment(DistanceQuery<?> distQ, DBIDs ids, int k) {
            this.distQ = distQ;
            this.ids = ids;
            this.medoids = DBIDUtil.newArray((int)k);
            this.miter = this.medoids.iter();
            this.assignment = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)3, (int)-1);
            this.nearest = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
            this.secondid = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)3, (int)-1);
            this.second = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
        }

        protected double computeCostDifferential(DBIDRef h, int mnum, Assignment scratch) {
            scratch.medoids.clear().addDBIDs((DBIDs)this.medoids);
            scratch.medoids.set(mnum, h);
            double cost = 0.0;
            DBIDIter j = this.ids.iter();
            while (j.valid()) {
                if (DBIDUtil.equal((DBIDRef)h, (DBIDRef)j)) {
                    scratch.recompute((DBIDRef)j, mnum, 0.0, -1, Double.POSITIVE_INFINITY);
                } else {
                    double distcur = this.nearest.doubleValue((DBIDRef)j);
                    double dist_h = this.distQ.distance(h, (DBIDRef)j);
                    int jcur = this.assignment.intValue((DBIDRef)j);
                    if (jcur == mnum) {
                        double distsec = this.second.doubleValue((DBIDRef)j);
                        if (dist_h < distsec) {
                            cost += dist_h - distcur;
                            scratch.assignment.putInt((DBIDRef)j, mnum);
                            scratch.nearest.putDouble((DBIDRef)j, dist_h);
                            scratch.second.putDouble((DBIDRef)j, distsec);
                            scratch.secondid.putInt((DBIDRef)j, jcur);
                        } else {
                            cost += distsec - distcur;
                            scratch.recompute((DBIDRef)j, mnum, dist_h, jcur, distsec);
                        }
                    } else if (dist_h < distcur) {
                        cost += dist_h - distcur;
                        scratch.assignment.putInt((DBIDRef)j, mnum);
                        scratch.nearest.putDouble((DBIDRef)j, dist_h);
                        scratch.second.putDouble((DBIDRef)j, distcur);
                        scratch.secondid.putInt((DBIDRef)j, jcur);
                    } else {
                        int jsec = this.secondid.intValue((DBIDRef)j);
                        double distsec = this.second.doubleValue((DBIDRef)j);
                        if (jsec != mnum && distsec <= dist_h) {
                            scratch.assignment.putInt((DBIDRef)j, jcur);
                            scratch.nearest.putDouble((DBIDRef)j, distcur);
                            scratch.secondid.putInt((DBIDRef)j, jsec);
                            scratch.second.putDouble((DBIDRef)j, distsec);
                        } else {
                            scratch.recompute((DBIDRef)j, jcur, distcur, mnum, dist_h);
                        }
                    }
                }
                j.advance();
            }
            return cost;
        }

        protected double recompute(DBIDRef id, int mnum, double known, int snum, double sknown) {
            double mindist = mnum >= 0 ? known : Double.POSITIVE_INFINITY;
            double mindist2 = Double.POSITIVE_INFINITY;
            int minIndex = mnum;
            int minIndex2 = -1;
            int i = 0;
            while (this.miter.seek(i).valid()) {
                if (i != mnum) {
                    double dist;
                    double d = dist = i == snum ? sknown : this.distQ.distance(id, (DBIDRef)this.miter);
                    if (DBIDUtil.equal((DBIDRef)id, (DBIDRef)this.miter) || dist < mindist) {
                        minIndex2 = minIndex;
                        mindist2 = mindist;
                        minIndex = i;
                        mindist = dist;
                    } else if (dist < mindist2) {
                        minIndex2 = i;
                        mindist2 = dist;
                    }
                }
                ++i;
            }
            if (minIndex < 0) {
                throw new AbortException("Too many infinite distances. Cannot assign objects.");
            }
            this.assignment.putInt(id, minIndex);
            this.nearest.putDouble(id, mindist);
            this.secondid.putInt(id, minIndex2);
            this.second.putDouble(id, mindist2);
            return mindist;
        }

        protected double assignToNearestCluster() {
            double cost = 0.0;
            DBIDIter iditer = this.ids.iter();
            while (iditer.valid()) {
                cost += this.recompute((DBIDRef)iditer, -1, Double.POSITIVE_INFINITY, -1, Double.POSITIVE_INFINITY);
                iditer.advance();
            }
            return cost;
        }
    }
}

