/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmedoids;

import elki.clustering.kmedoids.PAM;
import elki.clustering.kmedoids.initialization.KMedoidsInitialization;
import elki.data.Clustering;
import elki.data.model.MedoidModel;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.IndefiniteProgress;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Duration;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;

@Priority(value=-100)
@References(value={@Reference(authors="R. A. Whitaker", title="A Fast Algorithm For The Greedy Interchange For Large-Scale Clustering And Median Location Problems", booktitle="INFOR: Information Systems and Operational Research 21(2)", url="https://doi.org/10.1080/03155986.1983.11731889", bibkey="doi:10.1080/03155986.1983.11731889"), @Reference(authors="V. Estivill-Castro and A. T. Murray", title="Discovering Associations in Spatial Data - An Efficient Medoid Based Approach", booktitle="Proc. 2nd Pacific-Asia Conf. on Research and Development in Knowledge Discovery and Data Mining, PAKDD-98", url="https://doi.org/10.1007/3-540-64383-4_10", bibkey="DBLP:conf/pakdd/Estivill-CastroM98")})
public class EagerPAM<O>
extends PAM<O> {
    private static final Logging LOG = Logging.getLogger(EagerPAM.class);
    private static final String KEY = EagerPAM.class.getName();

    public EagerPAM(Distance<? super O> distance, int k, int maxiter, KMedoidsInitialization<O> initializer) {
        super(distance, k, maxiter, initializer);
    }

    @Override
    public Clustering<MedoidModel> run(Relation<O> relation, int k, DistanceQuery<? super O> distQ) {
        DBIDs ids = relation.getDBIDs();
        ArrayModifiableDBIDs medoids = this.initialMedoids(distQ, ids, k);
        WritableIntegerDataStore assignment = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)3, (int)-1);
        Duration optd = this.getLogger().newDuration(this.getClass().getName() + ".optimization-time").begin();
        new Instance(distQ, ids, assignment).run(medoids, this.maxiter);
        this.getLogger().statistics((Statistic)optd.end());
        return EagerPAM.wrapResult(ids, assignment, medoids, "EagerPAM Clustering");
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<O>
    extends PAM.Par<O> {
        @Override
        public EagerPAM<O> make() {
            return new EagerPAM(this.distance, this.k, this.maxiter, this.initializer);
        }
    }

    protected static class Instance
    extends PAM.Instance {
        public Instance(DistanceQuery<?> distQ, DBIDs ids, WritableIntegerDataStore assignment) {
            super(distQ, ids, assignment);
        }

        @Override
        protected double run(ArrayModifiableDBIDs medoids, int maxiter) {
            double tc;
            int k = medoids.size();
            double nc = tc = this.assignToNearestCluster((ArrayDBIDs)medoids);
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new DoubleStatistic(KEY + ".iteration-" + 0 + ".cost", tc));
            }
            boolean metric = this.distQ.getDistance().isMetric();
            IndefiniteProgress prog = LOG.isVerbose() ? new IndefiniteProgress("PAM iteration", LOG) : null;
            DBIDArrayMIter m = medoids.iter();
            DBIDVar lastswap = DBIDUtil.newVar();
            int iteration = 0;
            int prevswaps = 0;
            int swaps = 0;
            while (iteration < maxiter || maxiter <= 0) {
                ++iteration;
                LOG.incrementProcessed((AbstractProgress)prog);
                DBIDIter h = this.ids.iter();
                while (h.valid() && !DBIDUtil.equal((DBIDRef)h, (DBIDRef)lastswap)) {
                    if (!DBIDUtil.equal((DBIDRef)m.seek(this.assignment.intValue((DBIDRef)h)), (DBIDRef)h)) {
                        double hdist = this.nearest.doubleValue((DBIDRef)h);
                        if (!metric || !(hdist <= 0.0)) {
                            for (int pi = 0; pi < k; ++pi) {
                                double cpi = this.computeReassignmentCost((DBIDRef)h, pi) - hdist;
                                if (!(cpi < -1.0E-12 * nc)) continue;
                                ++swaps;
                                medoids.set(pi, (DBIDRef)h);
                                lastswap.set((DBIDRef)h);
                                nc = this.assignToNearestCluster((ArrayDBIDs)medoids);
                                if (!LOG.isStatistics()) break;
                                LOG.statistics((Statistic)new DoubleStatistic(KEY + ".swap-" + swaps + ".cost", nc));
                                break;
                            }
                        }
                    }
                    h.advance();
                }
                if (LOG.isStatistics()) {
                    LOG.statistics((Statistic)new LongStatistic(KEY + ".iteration-" + iteration + ".swaps", (long)(swaps - prevswaps)));
                }
                if (prevswaps == swaps) break;
                if (nc > tc) {
                    LOG.warning((CharSequence)"EagerPAM failed to converge (numerical instability?)");
                    break;
                }
                tc = nc;
                prevswaps = swaps;
            }
            LOG.setCompleted(prog);
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new LongStatistic(KEY + ".swaps", (long)swaps));
                LOG.statistics((Statistic)new LongStatistic(KEY + ".iterations", (long)iteration));
                LOG.statistics((Statistic)new DoubleStatistic(KEY + ".final-cost", tc));
            }
            return tc;
        }
    }
}

