/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmedoids;

import elki.clustering.ClusteringAlgorithmUtil;
import elki.clustering.kmedoids.CLARANS;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.MedoidModel;
import elki.database.datastore.IntegerDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Statistic;
import elki.result.Metadata;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import elki.utilities.exceptions.AbortException;
import elki.utilities.random.RandomFactory;
import java.util.Arrays;
import java.util.Random;

@Reference(authors="Erich Schubert, Peter J. Rousseeuw", title="Faster k-Medoids Clustering: Improving the PAM, CLARA, and CLARANS Algorithms", booktitle="Proc. 12th Int. Conf. Similarity Search and Applications (SISAP'2019)", url="https://doi.org/10.1007/978-3-030-32047-8_16", bibkey="DBLP:conf/sisap/SchubertR19")
@Priority(value=101)
public class FastCLARANS<V>
extends CLARANS<V> {
    private static final Logging LOG = Logging.getLogger(FastCLARANS.class);

    public FastCLARANS(Distance<? super V> distance, int k, int numlocal, double maxneighbor, RandomFactory random) {
        super(distance, k, numlocal, maxneighbor, random);
    }

    @Override
    public Clustering<MedoidModel> run(Relation<V> relation) {
        if (this.k * 2 >= relation.size()) {
            LOG.warning((CharSequence)"A very large k was chosen. This implementation is not optimized for this case.");
        }
        DBIDs ids = relation.getDBIDs();
        DistanceQuery distQ = new QueryBuilder(relation, this.distance).distanceQuery();
        boolean metric = this.distance.isMetric();
        int retries = (int)Math.ceil(this.maxneighbor < 1.0 ? this.maxneighbor * (double)(ids.size() - this.k) : this.maxneighbor);
        Random rnd = this.random.getSingleThreadedRandom();
        ArrayModifiableDBIDs subsampler = DBIDUtil.newArray((DBIDs)ids);
        DBIDArrayMIter cand = subsampler.iter();
        Assignment best = new Assignment(distQ, ids, this.k);
        Assignment curr = new Assignment(distQ, ids, this.k);
        double[] pcost = new double[this.k];
        double bestscore = Double.POSITIVE_INFINITY;
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("CLARANS sampling restarts", this.numlocal, LOG) : null;
        for (int i = 0; i < this.numlocal; ++i) {
            curr.medoids.clear().addDBIDs((DBIDs)DBIDUtil.randomSample((DBIDs)ids, (int)this.k, (Random)rnd));
            double total = curr.assignToNearestCluster();
            curr.computeRemovalCost(pcost);
            int j = 1;
            block1: while (j < retries) {
                double cost;
                for (int r = 0; r < ids.size(); ++r) {
                    subsampler.swap(r, rnd.nextInt(ids.size() - r) + r);
                    cand.seek(r);
                    if (curr.nearest.doubleValue((DBIDRef)cand) > 0.0) break;
                    if (metric && curr.second.doubleValue((DBIDRef)cand) == 0.0) {
                        ++j;
                        continue block1;
                    }
                    if (!metric && !curr.medoids.contains((DBIDRef)cand)) break;
                    if (r < 1000) continue;
                    throw new AbortException("Failed to choose a non-medoid in 1000 attempts. Choose k << N.");
                }
                if (!((cost = curr.computeCostDifferential((DBIDRef)cand, pcost)) < -1.0E-12 * total)) {
                    ++j;
                    continue;
                }
                total += cost;
                curr.performLastSwap((DBIDRef)cand);
                curr.computeRemovalCost(pcost);
                j = 1;
            }
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new DoubleStatistic(this.getClass().getName() + ".sample-" + i + ".cost", total));
            }
            if (total < bestscore) {
                Assignment tmp = curr;
                curr = best;
                best = tmp;
                bestscore = total;
            }
            LOG.incrementProcessed((AbstractProgress)prog);
        }
        LOG.ensureCompleted(prog);
        if (LOG.isStatistics()) {
            LOG.statistics((Statistic)new DoubleStatistic(this.getClass().getName() + ".final-cost", bestscore));
        }
        ArrayModifiableDBIDs[] clusters = ClusteringAlgorithmUtil.partitionsFromIntegerLabels(ids, (IntegerDataStore)best.assignment, this.k);
        Clustering<MedoidModel> result = new Clustering<MedoidModel>();
        Metadata.of(result).setLongName("CLARANS Clustering");
        DBIDArrayMIter it = best.medoids.iter();
        while (it.valid()) {
            result.addToplevelCluster(new Cluster<MedoidModel>((DBIDs)clusters[it.getOffset()], new MedoidModel(DBIDUtil.deref((DBIDRef)it))));
            it.advance();
        }
        return result;
    }

    public static class Par<V>
    extends CLARANS.Par<V> {
        @Override
        protected double defaultRate() {
            return 2.0 * super.defaultRate();
        }

        @Override
        public FastCLARANS<V> make() {
            return new FastCLARANS(this.distance, this.k, this.numlocal, this.maxneighbor, this.random);
        }
    }

    protected static class Assignment
    extends CLARANS.Assignment {
        double[] loss;
        protected int lastbest;

        public Assignment(DistanceQuery<?> distQ, DBIDs ids, int k) {
            super(distQ, ids, k);
            this.loss = new double[k];
        }

        protected void computeRemovalCost(double[] pcost) {
            Arrays.fill(pcost, 0.0);
            DBIDIter j = this.ids.iter();
            while (j.valid()) {
                int n = this.assignment.intValue((DBIDRef)j);
                pcost[n] = pcost[n] + (this.second.doubleValue((DBIDRef)j) - this.nearest.doubleValue((DBIDRef)j));
                j.advance();
            }
        }

        protected double computeCostDifferential(DBIDRef h, double[] pcost) {
            System.arraycopy(pcost, 0, this.loss, 0, pcost.length);
            double acc = 0.0;
            int k = this.loss.length;
            DBIDIter j = this.ids.iter();
            while (j.valid()) {
                double distcur = this.nearest.doubleValue((DBIDRef)j);
                double distsec = this.second.doubleValue((DBIDRef)j);
                double dist_h = this.distQ.distance(h, (DBIDRef)j);
                if (dist_h < distcur) {
                    acc += dist_h - distcur;
                    int n = this.assignment.intValue((DBIDRef)j);
                    this.loss[n] = this.loss[n] + (distcur - distsec);
                } else if (dist_h < distsec) {
                    int n = this.assignment.intValue((DBIDRef)j);
                    this.loss[n] = this.loss[n] + (dist_h - distsec);
                }
                j.advance();
            }
            double min = this.loss[0] = this.loss[0] + acc;
            this.lastbest = 0;
            for (int i = 1; i < k; ++i) {
                if (!(this.loss[i] < min)) continue;
                int n = i;
                double d = this.loss[n] + acc;
                this.loss[n] = d;
                min = d;
                this.lastbest = i;
            }
            return min;
        }

        protected void performLastSwap(DBIDRef h) {
            this.medoids.set(this.lastbest, h);
            DBIDIter j = this.ids.iter();
            while (j.valid()) {
                if (DBIDUtil.equal((DBIDRef)h, (DBIDRef)j)) {
                    this.recompute((DBIDRef)j, this.lastbest, 0.0, -1, Double.POSITIVE_INFINITY);
                } else {
                    double distcur = this.nearest.doubleValue((DBIDRef)j);
                    double dist_h = this.distQ.distance(h, (DBIDRef)j);
                    int jcur = this.assignment.intValue((DBIDRef)j);
                    if (jcur == this.lastbest) {
                        double distsec = this.second.doubleValue((DBIDRef)j);
                        if (dist_h < distsec) {
                            this.assignment.putInt((DBIDRef)j, this.lastbest);
                            this.nearest.putDouble((DBIDRef)j, dist_h);
                            this.second.putDouble((DBIDRef)j, distsec);
                            this.secondid.putInt((DBIDRef)j, jcur);
                        } else {
                            this.recompute((DBIDRef)j, this.lastbest, dist_h, jcur, distsec);
                        }
                    } else if (dist_h < distcur) {
                        this.assignment.putInt((DBIDRef)j, this.lastbest);
                        this.nearest.putDouble((DBIDRef)j, dist_h);
                        this.second.putDouble((DBIDRef)j, distcur);
                        this.secondid.putInt((DBIDRef)j, jcur);
                    } else {
                        int jsec = this.secondid.intValue((DBIDRef)j);
                        double distsec = this.second.doubleValue((DBIDRef)j);
                        if (jsec != this.lastbest && distsec <= dist_h) {
                            this.assignment.putInt((DBIDRef)j, jcur);
                            this.nearest.putDouble((DBIDRef)j, distcur);
                            this.secondid.putInt((DBIDRef)j, jsec);
                            this.second.putDouble((DBIDRef)j, distsec);
                        } else {
                            this.recompute((DBIDRef)j, jcur, distcur, this.lastbest, dist_h);
                        }
                    }
                }
                j.advance();
            }
        }
    }
}

