/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmedoids;

import elki.clustering.kmeans.initialization.RandomlyChosen;
import elki.clustering.kmedoids.FastPAM1;
import elki.clustering.kmedoids.initialization.KMedoidsInitialization;
import elki.data.Clustering;
import elki.data.model.MedoidModel;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.IndefiniteProgress;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Duration;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.math.linearalgebra.VMath;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Arrays;

@Priority(value=102)
@Reference(authors="Erich Schubert, Peter J. Rousseeuw", title="Faster k-Medoids Clustering: Improving the PAM, CLARA, and CLARANS Algorithms", booktitle="Proc. 12th Int. Conf. Similarity Search and Applications (SISAP'2019)", url="https://doi.org/10.1007/978-3-030-32047-8_16", bibkey="DBLP:conf/sisap/SchubertR19")
public class FastPAM<O>
extends FastPAM1<O> {
    private static final Logging LOG = Logging.getLogger(FastPAM.class);
    private static final String KEY = FastPAM.class.getName();
    protected double fasttol = 0.0;

    public FastPAM(Distance<? super O> distance, int k, int maxiter, KMedoidsInitialization<O> initializer) {
        this(distance, k, maxiter, initializer, 1.0);
    }

    public FastPAM(Distance<? super O> distance, int k, int maxiter, KMedoidsInitialization<O> initializer, double fasttol) {
        super(distance, k, maxiter, initializer);
        this.fasttol = fasttol;
    }

    @Override
    public Clustering<MedoidModel> run(Relation<O> relation, int k, DistanceQuery<? super O> distQ) {
        DBIDs ids = relation.getDBIDs();
        ArrayModifiableDBIDs medoids = this.initialMedoids(distQ, ids, k);
        WritableIntegerDataStore assignment = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)3, (int)-1);
        Duration optd = this.getLogger().newDuration(this.getClass().getName() + ".optimization-time").begin();
        new Instance(distQ, ids, assignment, this.fasttol).run(medoids, this.maxiter);
        this.getLogger().statistics((Statistic)optd.end());
        return FastPAM.wrapResult(ids, assignment, medoids, "PAM Clustering");
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V>
    extends FastPAM1.Par<V> {
        public static final OptionID FASTTOL_ID = new OptionID("pam.fasttol", "Tolerance for optimistically performing additional swaps, where 1 executes all fast swaps, 0 only those that are unaffected by the primary swaps.");
        protected double fasttol = 0.0;

        @Override
        protected Class<? extends KMedoidsInitialization> defaultInitializer() {
            return RandomlyChosen.class;
        }

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            ((DoubleParameter)((DoubleParameter)new DoubleParameter(FASTTOL_ID, 1.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_EQUAL_ONE_DOUBLE)).grab(config, x -> {
                this.fasttol = x;
            });
        }

        @Override
        public FastPAM<V> make() {
            return new FastPAM(this.distance, this.k, this.maxiter, this.initializer, this.fasttol);
        }
    }

    protected static class Instance
    extends FastPAM1.Instance {
        protected double fastswap = 0.0;

        public Instance(DistanceQuery<?> distQ, DBIDs ids, WritableIntegerDataStore assignment, double fasttol) {
            super(distQ, ids, assignment);
            this.fastswap = 1.0 - fasttol;
        }

        @Override
        protected double run(ArrayModifiableDBIDs medoids, int maxiter) {
            int k = medoids.size();
            double tc = this.assignToNearestCluster((ArrayDBIDs)medoids);
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new DoubleStatistic(KEY + ".iteration-" + 0 + ".cost", tc));
            }
            IndefiniteProgress prog = LOG.isVerbose() ? new IndefiniteProgress("PAM iteration", LOG) : null;
            int fastswaps = 0;
            DBIDArrayMIter m = medoids.iter();
            ArrayModifiableDBIDs bestids = DBIDUtil.newArray((int)k);
            DBIDVar bestid = DBIDUtil.newVar();
            double[] best = new double[k];
            double[] cost = new double[k];
            double[] pcost = new double[k];
            int iteration = 0;
            while (iteration < maxiter || maxiter <= 0) {
                ++iteration;
                LOG.incrementProcessed((AbstractProgress)prog);
                this.findBestSwaps((DBIDArrayIter)m, bestids, best, cost, pcost);
                int min = VMath.argmin((double[])best);
                if (!(best[min] < -1.0E-12 * tc)) break;
                block1: while (min >= 0 && best[min] < -1.0E-12 * tc) {
                    this.updateAssignment(medoids, (DBIDArrayIter)m, (DBIDRef)bestids.assignVar(min, bestid), min);
                    tc += best[min];
                    best[min] = Double.POSITIVE_INFINITY;
                    while ((min = VMath.argmin((double[])best)) >= 0 && best[min] < -1.0E-12 * tc) {
                        bestids.assignVar(min, bestid);
                        if (DBIDUtil.equal((DBIDRef)m.seek(this.assignment.intValue((DBIDRef)bestid) & Short.MAX_VALUE), (DBIDRef)bestid)) {
                            best[min] = Double.POSITIVE_INFINITY;
                            continue;
                        }
                        double hdist = this.nearest.doubleValue((DBIDRef)bestid);
                        double c = this.computeReassignmentCost((DBIDRef)bestid, min) - hdist;
                        if (c <= best[min] * this.fastswap) {
                            best[min] = c;
                            ++fastswaps;
                            continue block1;
                        }
                        best[min] = Double.POSITIVE_INFINITY;
                    }
                }
                if (!LOG.isStatistics()) continue;
                LOG.statistics((Statistic)new DoubleStatistic(KEY + ".iteration-" + iteration + ".cost", tc));
            }
            LOG.setCompleted(prog);
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new LongStatistic(KEY + ".iterations", (long)iteration));
                LOG.statistics((Statistic)new LongStatistic(KEY + ".fast-swaps", (long)fastswaps));
                LOG.statistics((Statistic)new DoubleStatistic(KEY + ".final-cost", tc));
            }
            DBIDIter it = this.ids.iter();
            while (it.valid()) {
                this.assignment.putInt((DBIDRef)it, this.assignment.intValue((DBIDRef)it) & Short.MAX_VALUE);
                it.advance();
            }
            return tc;
        }

        protected void findBestSwaps(DBIDArrayIter m, ArrayModifiableDBIDs bestids, double[] best, double[] cost, double[] pcost) {
            this.updatePriorCost(pcost);
            Arrays.fill(best, Double.POSITIVE_INFINITY);
            DBIDIter h = this.ids.iter();
            while (h.valid()) {
                if (!DBIDUtil.equal((DBIDRef)m.seek(this.assignment.intValue((DBIDRef)h) & Short.MAX_VALUE), (DBIDRef)h)) {
                    System.arraycopy(pcost, 0, cost, 0, pcost.length);
                    double acc = this.computeReassignmentCost((DBIDRef)h, cost);
                    for (int i = 0; i < cost.length; ++i) {
                        double costi = cost[i] + acc;
                        if (!(costi < best[i])) continue;
                        best[i] = costi;
                        bestids.set(i, (DBIDRef)h);
                    }
                }
                h.advance();
            }
        }

        @Override
        protected double computeReassignmentCost(DBIDRef h, int mnum) {
            double cost = 0.0;
            DBIDIter j = this.ids.iter();
            while (j.valid()) {
                if (!DBIDUtil.equal((DBIDRef)h, (DBIDRef)j)) {
                    double distcur = this.nearest.doubleValue((DBIDRef)j);
                    double dist_h = this.distQ.distance(h, (DBIDRef)j);
                    if ((this.assignment.intValue((DBIDRef)j) & Short.MAX_VALUE) == mnum) {
                        cost += Math.min(dist_h, this.second.doubleValue((DBIDRef)j)) - distcur;
                    } else if (dist_h < distcur) {
                        cost += dist_h - distcur;
                    }
                }
                j.advance();
            }
            return cost;
        }
    }
}

