/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmedoids;

import elki.clustering.kmedoids.PAM;
import elki.clustering.kmedoids.initialization.KMedoidsInitialization;
import elki.data.Clustering;
import elki.data.model.MedoidModel;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.IndefiniteProgress;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Duration;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import elki.utilities.exceptions.AbortException;
import java.util.Arrays;

@Reference(authors="Erich Schubert, Peter J. Rousseeuw", title="Faster k-Medoids Clustering: Improving the PAM, CLARA, and CLARANS Algorithms", booktitle="Proc. 12th Int. Conf. Similarity Search and Applications (SISAP'2019)", url="https://doi.org/10.1007/978-3-030-32047-8_16", bibkey="DBLP:conf/sisap/SchubertR19")
@Priority(value=-100)
public class FastPAM1<O>
extends PAM<O> {
    private static final Logging LOG = Logging.getLogger(FastPAM1.class);
    private static final String KEY = FastPAM1.class.getName();

    public FastPAM1(Distance<? super O> distance, int k, int maxiter, KMedoidsInitialization<O> initializer) {
        super(distance, k, maxiter, initializer);
    }

    @Override
    public Clustering<MedoidModel> run(Relation<O> relation, int k, DistanceQuery<? super O> distQ) {
        DBIDs ids = relation.getDBIDs();
        ArrayModifiableDBIDs medoids = this.initialMedoids(distQ, ids, k);
        WritableIntegerDataStore assignment = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)3, (int)-1);
        Duration optd = this.getLogger().newDuration(this.getClass().getName() + ".optimization-time").begin();
        new Instance(distQ, ids, assignment).run(medoids, this.maxiter);
        this.getLogger().statistics((Statistic)optd.end());
        return FastPAM1.wrapResult(ids, assignment, medoids, "PAM Clustering");
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V>
    extends PAM.Par<V> {
        @Override
        public FastPAM1<V> make() {
            return new FastPAM1(this.distance, this.k, this.maxiter, this.initializer);
        }
    }

    protected static class Instance
    extends PAM.Instance {
        public Instance(DistanceQuery<?> distQ, DBIDs ids, WritableIntegerDataStore assignment) {
            super(distQ, ids, assignment);
        }

        @Override
        protected double run(ArrayModifiableDBIDs medoids, int maxiter) {
            int k = medoids.size();
            double tc = this.assignToNearestCluster((ArrayDBIDs)medoids);
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new DoubleStatistic(KEY + ".iteration-" + 0 + ".cost", tc));
            }
            IndefiniteProgress prog = LOG.isVerbose() ? new IndefiniteProgress("PAM iteration", LOG) : null;
            DBIDVar bestid = DBIDUtil.newVar();
            DBIDArrayMIter m = medoids.iter();
            double[] cost = new double[k];
            double[] pcost = new double[k];
            int iteration = 0;
            while (iteration < maxiter || maxiter <= 0) {
                ++iteration;
                LOG.incrementProcessed((AbstractProgress)prog);
                this.updatePriorCost(pcost);
                double best = Double.POSITIVE_INFINITY;
                int bestcluster = -1;
                DBIDIter h = this.ids.iter();
                while (h.valid()) {
                    if (!DBIDUtil.equal((DBIDRef)m.seek(this.assignment.intValue((DBIDRef)h) & Short.MAX_VALUE), (DBIDRef)h)) {
                        System.arraycopy(pcost, 0, cost, 0, pcost.length);
                        double acc = this.computeReassignmentCost((DBIDRef)h, cost);
                        for (int i = 0; i < k; ++i) {
                            double costi = cost[i] + acc;
                            if (!(costi < best)) continue;
                            best = costi;
                            bestid.set((DBIDRef)h);
                            bestcluster = i;
                        }
                    }
                    h.advance();
                }
                if (!(best < -1.0E-12 * tc)) break;
                this.updateAssignment(medoids, (DBIDArrayIter)m, (DBIDRef)bestid, bestcluster);
                tc += best;
                if (!LOG.isStatistics()) continue;
                LOG.statistics((Statistic)new DoubleStatistic(KEY + ".iteration-" + iteration + ".cost", tc));
            }
            LOG.setCompleted(prog);
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new LongStatistic(KEY + ".iterations", (long)iteration));
                LOG.statistics((Statistic)new DoubleStatistic(KEY + ".final-cost", tc));
            }
            DBIDIter it = this.ids.iter();
            while (it.valid()) {
                this.assignment.putInt((DBIDRef)it, this.assignment.intValue((DBIDRef)it) & Short.MAX_VALUE);
                it.advance();
            }
            return tc;
        }

        protected void updatePriorCost(double[] pcost) {
            WritableIntegerDataStore a = this.assignment;
            WritableDoubleDataStore s = this.second;
            WritableDoubleDataStore n = this.nearest;
            Arrays.fill(pcost, 0.0);
            DBIDIter j = this.ids.iter();
            while (j.valid()) {
                int n2 = a.intValue((DBIDRef)j) & Short.MAX_VALUE;
                pcost[n2] = pcost[n2] + (s.doubleValue((DBIDRef)j) - n.doubleValue((DBIDRef)j));
                j.advance();
            }
        }

        @Override
        protected double assignToNearestCluster(ArrayDBIDs means) {
            DBIDArrayIter miter = means.iter();
            double cost = 0.0;
            DBIDIter iditer = this.ids.iter();
            while (iditer.valid()) {
                double mindist = Double.POSITIVE_INFINITY;
                double mindist2 = Double.POSITIVE_INFINITY;
                int minindx = -1;
                int minindx2 = -1;
                miter.seek(0);
                while (miter.valid()) {
                    double dist = this.distQ.distance((DBIDRef)iditer, (DBIDRef)miter);
                    if (dist < mindist) {
                        minindx2 = minindx;
                        mindist2 = mindist;
                        minindx = miter.getOffset();
                        mindist = dist;
                    } else if (dist < mindist2) {
                        minindx2 = miter.getOffset();
                        mindist2 = dist;
                    }
                    miter.advance();
                }
                if (minindx < 0) {
                    throw new AbortException("Too many infinite distances. Cannot assign objects.");
                }
                this.assignment.put((DBIDRef)iditer, minindx | minindx2 << 16);
                this.nearest.put((DBIDRef)iditer, mindist);
                this.second.put((DBIDRef)iditer, mindist2);
                cost += mindist;
                iditer.advance();
            }
            return cost;
        }

        protected double computeReassignmentCost(DBIDRef xj, double[] loss) {
            WritableDoubleDataStore nearest = this.nearest;
            WritableDoubleDataStore second = this.second;
            WritableIntegerDataStore assignment = this.assignment;
            double acc = 0.0;
            DBIDIter xo = this.ids.iter();
            while (xo.valid()) {
                double dn = nearest.doubleValue((DBIDRef)xo);
                double ds = second.doubleValue((DBIDRef)xo);
                double dxo = this.distQ.distance(xj, (DBIDRef)xo);
                if (dxo < dn) {
                    acc += dxo - dn;
                    int n = assignment.intValue((DBIDRef)xo) & Short.MAX_VALUE;
                    loss[n] = loss[n] + (dn - ds);
                } else if (dxo < ds) {
                    int n = assignment.intValue((DBIDRef)xo) & Short.MAX_VALUE;
                    loss[n] = loss[n] + (dxo - ds);
                }
                xo.advance();
            }
            return acc;
        }

        protected void updateAssignment(ArrayModifiableDBIDs medoids, DBIDArrayIter miter, DBIDRef h, int m) {
            medoids.set(m, h);
            double hdist = this.nearest.putDouble(h, 0.0);
            int olda = this.assignment.intValue(h);
            if ((olda & Short.MAX_VALUE) != m) {
                this.assignment.putInt(h, m | (olda & Short.MAX_VALUE) << 16);
                this.second.putDouble(h, hdist);
            } else {
                this.assignment.putInt(h, m | olda & 0x7FFF0000);
            }
            assert (DBIDUtil.equal((DBIDRef)h, (DBIDRef)miter.seek(m)));
            DBIDIter j = this.ids.iter();
            while (j.valid()) {
                if (!DBIDUtil.equal((DBIDRef)h, (DBIDRef)j)) {
                    double distcur = this.nearest.doubleValue((DBIDRef)j);
                    double distsec = this.second.doubleValue((DBIDRef)j);
                    double dist_h = this.distQ.distance(h, (DBIDRef)j);
                    int pj = this.assignment.intValue((DBIDRef)j);
                    int po = pj >>> 16;
                    if ((pj &= Short.MAX_VALUE) == m) {
                        if (dist_h < distsec) {
                            this.nearest.putDouble((DBIDRef)j, dist_h);
                        } else {
                            this.nearest.putDouble((DBIDRef)j, distsec);
                            this.assignment.putInt((DBIDRef)j, po | this.updateSecondNearest((DBIDRef)j, miter, m, dist_h, po) << 16);
                        }
                    } else if (dist_h < distcur) {
                        this.nearest.putDouble((DBIDRef)j, dist_h);
                        this.second.putDouble((DBIDRef)j, distcur);
                        this.assignment.putInt((DBIDRef)j, m | pj << 16);
                    } else if (po == m) {
                        this.assignment.putInt((DBIDRef)j, pj | this.updateSecondNearest((DBIDRef)j, miter, m, dist_h, pj) << 16);
                    } else if (dist_h < distsec) {
                        this.second.putDouble((DBIDRef)j, dist_h);
                        this.assignment.putInt((DBIDRef)j, pj | m << 16);
                    }
                }
                j.advance();
            }
        }

        protected int updateSecondNearest(DBIDRef j, DBIDArrayIter medoids, int h, double dist_h, int n) {
            double sdist = dist_h;
            int sbest = h;
            medoids.seek(0);
            while (medoids.valid()) {
                double d;
                if (medoids.getOffset() != h && medoids.getOffset() != n && (d = this.distQ.distance(j, (DBIDRef)medoids)) < sdist) {
                    sdist = d;
                    sbest = medoids.getOffset();
                }
                medoids.advance();
            }
            this.second.putDouble(j, sdist);
            return sbest;
        }
    }
}

