/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmedoids;

import elki.clustering.kmedoids.CLARA;
import elki.clustering.kmedoids.FasterPAM;
import elki.clustering.kmedoids.initialization.KMedoidsInitialization;
import elki.data.Clustering;
import elki.data.model.MedoidModel;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Statistic;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import java.util.Random;

@Reference(authors="Erich Schubert and Peter J. Rousseeuw", title="Fast and Eager k-Medoids Clustering: O(k) Runtime Improvement of the PAM, CLARA, and CLARANS Algorithms", booktitle="arXiv preprint", url="https://arxiv.org/abs/2008.05171", bibkey="DBLP:journals/corr/abs-2008-05171")
public class FasterCLARA<O>
extends FasterPAM<O> {
    private static final Logging LOG = Logging.getLogger(FasterCLARA.class);
    double sampling;
    int numsamples;
    boolean keepmed;
    RandomFactory random;

    public FasterCLARA(Distance<? super O> distance, int k, int maxiter, KMedoidsInitialization<O> initializer, int numsamples, double sampling, boolean keepmed, RandomFactory random) {
        super(distance, k, maxiter, initializer);
        this.numsamples = numsamples;
        this.sampling = sampling;
        this.random = random;
        this.keepmed = keepmed;
    }

    @Override
    public Clustering<MedoidModel> run(Relation<O> relation) {
        return this.run(relation, this.k, new QueryBuilder(relation, this.distance).distanceQuery());
    }

    @Override
    public Clustering<MedoidModel> run(Relation<O> relation, int k, DistanceQuery<? super O> distQ) {
        DBIDs ids = relation.getDBIDs();
        int samplesize = Math.min(ids.size(), (int)(this.sampling <= 1.0 ? this.sampling * (double)ids.size() : this.sampling));
        if (samplesize < 3 * k) {
            LOG.warning((CharSequence)"The sampling size is set to a very small value, it should be much larger than k.");
        }
        CLARA.CachedDistanceQuery<O> cachedQ = new CLARA.CachedDistanceQuery<O>(distQ, samplesize * (samplesize - 1) >> 1);
        double best = Double.POSITIVE_INFINITY;
        ArrayModifiableDBIDs bestmedoids = null;
        WritableIntegerDataStore bestclusters = null;
        Random rnd = this.random.getSingleThreadedRandom();
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Processing random samples", this.numsamples, LOG) : null;
        for (int j = 0; j < this.numsamples; ++j) {
            DBIDs rids = CLARA.randomSample(ids, samplesize, rnd, this.keepmed ? bestmedoids : null);
            cachedQ.clear();
            ArrayModifiableDBIDs medoids = DBIDUtil.newArray((DBIDs)this.initializer.chooseInitialMedoids(k, rids, cachedQ));
            WritableIntegerDataStore assignment = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)3, (int)-1);
            double score = new FasterPAM.Instance(cachedQ, rids, assignment).run(medoids, this.maxiter) + CLARA.assignRemainingToNearestCluster((ArrayDBIDs)medoids, ids, rids, assignment, distQ);
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new DoubleStatistic(this.getClass().getName() + ".sample-" + j + ".cost", score));
            }
            if (score < best) {
                best = score;
                bestmedoids = medoids;
                bestclusters = assignment;
            }
            if (cachedQ.hasUncachedQueries()) {
                LOG.warning((CharSequence)"Some distance queries were not cached; maybe the initialization is not optimized for k-medoids.");
            }
            LOG.incrementProcessed((AbstractProgress)prog);
        }
        LOG.ensureCompleted(prog);
        if (LOG.isStatistics()) {
            LOG.statistics((Statistic)new DoubleStatistic(this.getClass().getName() + ".final-cost", best));
        }
        if (bestmedoids == null) {
            throw new IllegalStateException("numsamples must be larger than 0.");
        }
        return FasterCLARA.wrapResult(ids, bestclusters, bestmedoids, "CLARA Clustering");
    }

    public static class Par<V>
    extends FasterPAM.Par<V> {
        public static final OptionID NUMSAMPLES_ID = CLARA.Par.NUMSAMPLES_ID;
        public static final OptionID SAMPLESIZE_ID = CLARA.Par.SAMPLESIZE_ID;
        public static final OptionID NOKEEPMED_ID = CLARA.Par.NOKEEPMED_ID;
        public static final OptionID RANDOM_ID = CLARA.Par.RANDOM_ID;
        double sampling;
        int numsamples;
        boolean keepmed;
        RandomFactory random;

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            ((IntParameter)new IntParameter(NUMSAMPLES_ID, 5).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.numsamples = x;
            });
            ((DoubleParameter)new DoubleParameter(SAMPLESIZE_ID, 80.0 + 4.0 * (double)this.k).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).grab(config, x -> {
                this.sampling = x;
            });
            if (this.numsamples > 1) {
                new Flag(NOKEEPMED_ID).grab(config, x -> {
                    this.keepmed = !x;
                });
            }
            new RandomParameter(RANDOM_ID).grab(config, x -> {
                this.random = x;
            });
        }

        @Override
        public FasterCLARA<V> make() {
            return new FasterCLARA(this.distance, this.k, this.maxiter, this.initializer, this.numsamples, this.sampling, this.keepmed, this.random);
        }
    }
}

