/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmedoids;

import elki.clustering.kmedoids.FastPAM;
import elki.clustering.kmedoids.initialization.KMedoidsInitialization;
import elki.data.Clustering;
import elki.data.model.MedoidModel;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.IndefiniteProgress;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Duration;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.math.linearalgebra.VMath;
import elki.utilities.documentation.Reference;

@Reference(authors="Erich Schubert and Peter J. Rousseeuw", title="Fast and Eager k-Medoids Clustering: O(k) Runtime Improvement of the PAM, CLARA, and CLARANS Algorithms", booktitle="arXiv preprint", url="https://arxiv.org/abs/2008.05171", bibkey="DBLP:journals/corr/abs-2008-05171")
public class FasterPAM<O>
extends FastPAM<O> {
    private static final Logging LOG = Logging.getLogger(FasterPAM.class);
    private static final String KEY = FasterPAM.class.getName();

    public FasterPAM(Distance<? super O> distance, int k, int maxiter, KMedoidsInitialization<O> initializer) {
        super(distance, k, maxiter, initializer);
    }

    @Override
    public Clustering<MedoidModel> run(Relation<O> relation, int k, DistanceQuery<? super O> distQ) {
        DBIDs ids = relation.getDBIDs();
        ArrayModifiableDBIDs medoids = this.initialMedoids(distQ, ids, k);
        WritableIntegerDataStore assignment = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)3, (int)-1);
        Duration optd = this.getLogger().newDuration(this.getClass().getName() + ".optimization-time").begin();
        new Instance(distQ, ids, assignment).run(medoids, this.maxiter);
        this.getLogger().statistics((Statistic)optd.end());
        return FasterPAM.wrapResult(ids, assignment, medoids, "FasterPAM Clustering");
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<O>
    extends FastPAM.Par<O> {
        @Override
        public FasterPAM<O> make() {
            return new FasterPAM(this.distance, this.k, this.maxiter, this.initializer);
        }
    }

    protected static class Instance
    extends FastPAM.Instance {
        public Instance(DistanceQuery<?> distQ, DBIDs ids, WritableIntegerDataStore assignment) {
            super(distQ, ids, assignment, 1.0);
        }

        @Override
        protected double run(ArrayModifiableDBIDs medoids, int maxiter) {
            int k = medoids.size();
            double tc = this.assignToNearestCluster((ArrayDBIDs)medoids);
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new DoubleStatistic(KEY + ".iteration-" + 0 + ".cost", tc));
            }
            IndefiniteProgress prog = LOG.isVerbose() ? new IndefiniteProgress("FasterPAM iteration", LOG) : null;
            double[] cost = new double[k];
            double[] pcost = new double[k];
            this.updatePriorCost(pcost);
            DBIDArrayMIter m = medoids.iter();
            DBIDVar lastswap = DBIDUtil.newVar();
            int iteration = 0;
            int prevswaps = 0;
            int swaps = 0;
            while (iteration < maxiter || maxiter <= 0) {
                ++iteration;
                LOG.incrementProcessed((AbstractProgress)prog);
                DBIDIter h = this.ids.iter();
                while (h.valid() && !DBIDUtil.equal((DBIDRef)h, (DBIDRef)lastswap)) {
                    if (!DBIDUtil.equal((DBIDRef)m.seek(this.assignment.intValue((DBIDRef)h) & Short.MAX_VALUE), (DBIDRef)h)) {
                        System.arraycopy(pcost, 0, cost, 0, pcost.length);
                        double acc = this.computeReassignmentCost((DBIDRef)h, cost);
                        int min = VMath.argmin((double[])cost);
                        double bestcost = cost[min] + acc;
                        if (bestcost < -1.0E-12 * tc) {
                            ++swaps;
                            lastswap.set((DBIDRef)h);
                            this.updateAssignment(medoids, (DBIDArrayIter)m, (DBIDRef)h, min);
                            this.updatePriorCost(pcost);
                            assert ((tc += bestcost) >= 0.0);
                            if (LOG.isStatistics()) {
                                LOG.statistics((Statistic)new DoubleStatistic(KEY + ".swap-" + swaps + ".cost", tc));
                            }
                        }
                    }
                    h.advance();
                }
                if (LOG.isStatistics()) {
                    LOG.statistics((Statistic)new LongStatistic(KEY + ".iteration-" + iteration + ".swaps", (long)(swaps - prevswaps)));
                }
                if (prevswaps == swaps) break;
                prevswaps = swaps;
                if (!LOG.isStatistics()) continue;
                LOG.statistics((Statistic)new DoubleStatistic(KEY + ".iteration-" + iteration + ".cost", tc));
            }
            LOG.setCompleted(prog);
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new LongStatistic(KEY + ".iterations", (long)iteration));
                LOG.statistics((Statistic)new LongStatistic(KEY + ".swaps", (long)swaps));
                LOG.statistics((Statistic)new DoubleStatistic(KEY + ".final-cost", tc));
            }
            DBIDIter it = this.ids.iter();
            while (it.valid()) {
                this.assignment.putInt((DBIDRef)it, this.assignment.intValue((DBIDRef)it) & Short.MAX_VALUE);
                it.advance();
            }
            return tc;
        }
    }
}

