/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmedoids;

import elki.Algorithm;
import elki.clustering.ClusteringAlgorithmUtil;
import elki.clustering.kmeans.KMeans;
import elki.clustering.kmedoids.KMedoidsClustering;
import elki.clustering.kmedoids.initialization.BUILD;
import elki.clustering.kmedoids.initialization.KMedoidsInitialization;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.MedoidModel;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.IntegerDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.IndefiniteProgress;
import elki.logging.statistics.DoubleStatistic;
import elki.logging.statistics.Duration;
import elki.logging.statistics.LongStatistic;
import elki.logging.statistics.Statistic;
import elki.logging.statistics.StringStatistic;
import elki.result.Metadata;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.documentation.Title;
import elki.utilities.exceptions.AbortException;
import elki.utilities.exceptions.NotImplementedException;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="Partioning Around Medoids")
@Priority(value=100)
@References(value={@Reference(authors="L. Kaufman, P. J. Rousseeuw", title="Clustering by means of Medoids", booktitle="Statistical Data Analysis Based on the L1-Norm and Related Methods", bibkey="books/misc/KauRou87"), @Reference(authors="L. Kaufman, P. J. Rousseeuw", title="Partitioning Around Medoids (Program PAM)", booktitle="Finding Groups in Data: An Introduction to Cluster Analysis", url="https://doi.org/10.1002/9780470316801.ch2", bibkey="doi:10.1002/9780470316801.ch2"), @Reference(authors="R. A. Whitaker", title="A Fast Algorithm For The Greedy Interchange For Large-Scale Clustering And Median Location Problems", booktitle="INFOR: Information Systems and Operational Research 21(2)", url="https://doi.org/10.1080/03155986.1983.11731889", bibkey="doi:10.1080/03155986.1983.11731889")})
public class PAM<O>
implements KMedoidsClustering<O> {
    private static final Logging LOG = Logging.getLogger(PAM.class);
    protected Distance<? super O> distance;
    protected int k;
    protected int maxiter;
    protected KMedoidsInitialization<O> initializer;

    public PAM(Distance<? super O> distance, int k, int maxiter, KMedoidsInitialization<O> initializer) {
        if (k > Short.MAX_VALUE) {
            throw new NotImplementedException("PAM supports at most 32767 clusters.");
        }
        this.distance = distance;
        this.k = k;
        this.maxiter = maxiter;
        this.initializer = initializer;
    }

    @Override
    public Clustering<MedoidModel> run(Relation<O> relation) {
        return this.run(relation, this.k, new QueryBuilder(relation, this.distance).precomputed().distanceQuery());
    }

    @Override
    public Clustering<MedoidModel> run(Relation<O> relation, int k, DistanceQuery<? super O> distQ) {
        DBIDs ids = relation.getDBIDs();
        ArrayModifiableDBIDs medoids = this.initialMedoids(distQ, ids, k);
        WritableIntegerDataStore assignment = DataStoreUtil.makeIntegerStorage((DBIDs)ids, (int)3, (int)-1);
        Duration optd = this.getLogger().newDuration(this.getClass().getName() + ".optimization-time").begin();
        new Instance(distQ, ids, assignment).run(medoids, this.maxiter);
        this.getLogger().statistics((Statistic)optd.end());
        return PAM.wrapResult(ids, assignment, medoids, "PAM Clustering");
    }

    protected ArrayModifiableDBIDs initialMedoids(DistanceQuery<? super O> distQ, DBIDs ids, int k) {
        if (this.getLogger().isStatistics()) {
            this.getLogger().statistics((Statistic)new StringStatistic(this.getClass().getName() + ".initialization", this.initializer.toString()));
        }
        Duration initd = this.getLogger().newDuration(this.getClass().getName() + ".initialization-time").begin();
        ArrayModifiableDBIDs medoids = DBIDUtil.newArray((DBIDs)this.initializer.chooseInitialMedoids(k, ids, distQ));
        this.getLogger().statistics((Statistic)initd.end());
        if (medoids.size() != k) {
            throw new AbortException("Initializer " + this.initializer.toString() + " did not return " + k + " means, but " + medoids.size());
        }
        return medoids;
    }

    protected static Clustering<MedoidModel> wrapResult(DBIDs ids, WritableIntegerDataStore assignment, ArrayModifiableDBIDs medoids, String name) {
        ArrayModifiableDBIDs[] clusters = ClusteringAlgorithmUtil.partitionsFromIntegerLabels(ids, (IntegerDataStore)assignment, medoids.size());
        Clustering<MedoidModel> result = new Clustering<MedoidModel>();
        Metadata.of(result).setLongName(name);
        DBIDArrayMIter it = medoids.iter();
        while (it.valid()) {
            result.addToplevelCluster(new Cluster<MedoidModel>((DBIDs)clusters[it.getOffset()], new MedoidModel(DBIDUtil.deref((DBIDRef)it))));
            it.advance();
        }
        return result;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<O>
    implements Parameterizer {
        protected int k;
        protected int maxiter;
        protected KMedoidsInitialization<O> initializer;
        protected Distance<? super O> distance;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(KMeans.K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
            new ObjectParameter(KMeans.INIT_ID, KMedoidsInitialization.class, this.defaultInitializer()).grab(config, x -> {
                this.initializer = x;
            });
            ((IntParameter)new IntParameter(KMeans.MAXITER_ID, 0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ZERO_INT)).grab(config, x -> {
                this.maxiter = x;
            });
        }

        protected Class<? extends KMedoidsInitialization> defaultInitializer() {
            return BUILD.class;
        }

        public PAM<O> make() {
            return new PAM<O>(this.distance, this.k, this.maxiter, this.initializer);
        }
    }

    protected static class Instance {
        DBIDs ids;
        DistanceQuery<?> distQ;
        WritableDoubleDataStore nearest;
        WritableDoubleDataStore second;
        WritableIntegerDataStore assignment;

        public Instance(DistanceQuery<?> distQ, DBIDs ids, WritableIntegerDataStore assignment) {
            this.distQ = distQ;
            this.ids = ids;
            this.assignment = assignment;
            this.nearest = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
            this.second = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
        }

        protected double run(ArrayModifiableDBIDs medoids, int maxiter) {
            int k = medoids.size();
            double tc = this.assignToNearestCluster((ArrayDBIDs)medoids);
            String key = this.getClass().getName().replace("$Instance", "");
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new DoubleStatistic(key + ".iteration-" + 0 + ".cost", tc));
            }
            boolean metric = this.distQ.getDistance().isMetric();
            IndefiniteProgress prog = LOG.isVerbose() ? new IndefiniteProgress("PAM iteration", LOG) : null;
            DBIDVar bestid = DBIDUtil.newVar();
            DBIDArrayMIter m = medoids.iter();
            int iteration = 0;
            while (iteration < maxiter || maxiter <= 0) {
                ++iteration;
                LOG.incrementProcessed((AbstractProgress)prog);
                double best = Double.POSITIVE_INFINITY;
                int bestcluster = -1;
                DBIDIter h = this.ids.iter();
                while (h.valid()) {
                    if (!DBIDUtil.equal((DBIDRef)m.seek(this.assignment.intValue((DBIDRef)h)), (DBIDRef)h)) {
                        double hdist = this.nearest.doubleValue((DBIDRef)h);
                        if (!metric || !(hdist <= 0.0)) {
                            for (int pi = 0; pi < k; ++pi) {
                                double cpi = this.computeReassignmentCost((DBIDRef)h, pi) - hdist;
                                if (!(cpi < best)) continue;
                                best = cpi;
                                bestid.set((DBIDRef)h);
                                bestcluster = pi;
                            }
                        }
                    }
                    h.advance();
                }
                if (!(best < -1.0E-12 * tc)) break;
                medoids.set(bestcluster, (DBIDRef)bestid);
                double nc = this.assignToNearestCluster((ArrayDBIDs)medoids);
                if (LOG.isStatistics()) {
                    LOG.statistics((Statistic)new DoubleStatistic(key + ".iteration-" + iteration + ".cost", nc));
                }
                if (nc > tc) {
                    if (nc - tc < 1.0E-7 * tc) {
                        LOG.warning((CharSequence)"PAM failed to converge (numerical instability?)");
                        break;
                    }
                    LOG.warning((CharSequence)("PAM failed to converge: costs increased by: " + (nc - tc) + " exepected a decrease by " + best));
                    break;
                }
                tc = nc;
            }
            LOG.setCompleted(prog);
            if (LOG.isStatistics()) {
                LOG.statistics((Statistic)new LongStatistic(key + ".iterations", (long)iteration));
                LOG.statistics((Statistic)new DoubleStatistic(key + ".final-cost", tc));
            }
            return tc;
        }

        protected double computeReassignmentCost(DBIDRef h, int mnum) {
            double cost = 0.0;
            DBIDIter j = this.ids.iter();
            while (j.valid()) {
                if (!DBIDUtil.equal((DBIDRef)h, (DBIDRef)j)) {
                    double distcur = this.nearest.doubleValue((DBIDRef)j);
                    double dist_h = this.distQ.distance(h, (DBIDRef)j);
                    if (this.assignment.intValue((DBIDRef)j) == mnum) {
                        cost += Math.min(dist_h, this.second.doubleValue((DBIDRef)j)) - distcur;
                    } else if (dist_h < distcur) {
                        cost += dist_h - distcur;
                    }
                }
                j.advance();
            }
            return cost;
        }

        protected double assignToNearestCluster(ArrayDBIDs means) {
            DBIDArrayIter miter = means.iter();
            double cost = 0.0;
            DBIDIter iditer = this.ids.iter();
            while (iditer.valid()) {
                double mindist = Double.POSITIVE_INFINITY;
                double mindist2 = Double.POSITIVE_INFINITY;
                int minindx = -1;
                miter.seek(0);
                while (miter.valid()) {
                    double dist = this.distQ.distance((DBIDRef)iditer, (DBIDRef)miter);
                    if (dist < mindist) {
                        mindist2 = mindist;
                        minindx = miter.getOffset();
                        mindist = dist;
                    } else if (dist < mindist2) {
                        mindist2 = dist;
                    }
                    miter.advance();
                }
                if (minindx < 0) {
                    throw new AbortException("Too many infinite distances. Cannot assign objects.");
                }
                this.assignment.put((DBIDRef)iditer, minindx);
                this.nearest.put((DBIDRef)iditer, mindist);
                this.second.put((DBIDRef)iditer, mindist2);
                cost += mindist;
                iditer.advance();
            }
            return cost;
        }
    }
}

